:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::               WPU Reboot Batch Script                     ::
::                         V1.1                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2017/09/08                           ::
::                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@echo off
:: This Script is to daily restart the WPU after the first train of the day

:: CONFIGURATION AREA

:: Hour of the day Greater than or equal to when the script can run once. This is a space seperated list if you need more than once a day
set HOUR_OF_DAY_TO_RESET=0 12

set EXE_FILE=shutdown -r -f -t 360
set DEL_FILE=
set PDUDelayWait=60

IF NOT DEFINED SROutputLogFiles SET SROutputLogFiles=28

:: END CONFIGURATION AREA
SETLOCAL ENABLEDELAYEDEXPANSION
IF NOT EXIST "%~dp0log\." mkdir "%~dp0log"

ECHO %DATE% %TIME% WPU Reboot Batch Script will run after %HOUR_OF_DAY_TO_RESET% every day to recover. | "%~dp0TEE" -a "%~dp0\log\WPU.%DATE:/=-%.%~n0.log"

for %%A IN (%HOUR_OF_DAY_TO_RESET%) DO (
    IF NOT EXIST "%~dp0log\WPU.%DATE:/=-%.%%A.done" IF %TIME:~0,2% GEQ %%A (
        START "WPU Reboot EXE_FILE" /MIN %EXE_FILE%  &&ECHO. 2>"%~dp0log\WPU.%DATE:/=-%.%%A.done"
        IF DEFINED DEL_FILE IF EXIST %DEL_FILE% DEL /Q %DEL_FILE% &&ECHO %DATE% %TIME% File %DEL_FILE% Deleted | "%~dp0TEE" -a "%~dp0log\WPU.%DATE:/=-%.%~n0.log"
        IF DEFINED PDUDelayWait if exist %windir%\system32\timeout.exe (timeout %PDUDelayWait% >nul ) ELSE (ping localhost -n %PDUDelayWait% >nul )
    )
    SET /a LOGMULTI= !LOGMULTI! + 1
) 

:: Tidy up Old Log Files based on how many files we want to keep.
for /f "tokens=* skip=%SROutputLogFiles%" %%A IN ('dir /B /O-D "%~dp0log\WPU.*.log"') DO DEL "%~dp0log\%%A"


SET /a LOGMULTI=%LOGMULTI% * %SROutputLogFiles%
for /f "tokens=* skip=%LOGMULTI%" %%A IN ('dir /B /O-D "%~dp0log\WPU.*.done" 2^>nul') DO DEL "%~dp0log\%%A"

ENDLOCAL