:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::   SMS service via MSG91 for SMS sending Batch Script      ::
::                         V1.2                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2020/05/01                           ::
::                                                           ::
::            Makes Use of 7z & curl command line            ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@ECHO OFF
:: Takes a telnetd input Text file and scripts it to run via telnetd. (initial purpose to send SMS via a Modem)
:: Log the telnetd output via file and keep the input Text file for X new report.
:: After X new reports, archive the telnetd log files and delete the input telnetd Text file (a copy exists in the train directory).
setlocal ENABLEDELAYEDEXPANSION
:: Enter Parameters below (Defaults Provided);
::===============================================================
:: Renamed Storage location e.g. D:\Server\Share\AVI_Files\
IF NOT DEFINED DIRFLS SET DIRFLS=D:\server\WMAout_T\SMS\

:: Incoming Temp Storage location e.g. D:\Server\Share\AVI_Files\Temp
IF NOT DEFINED DIR7Z SET DIR7Z=D:\server\WMAout_T\SMS\Log\

:: MSG91 sending Parameters
set sender=TIQALT
set route=4
set Authkey=179967AC4t1g1SBN8w59e7c7b7
set country=91

:: Number of x new reports to keep
SET KeepLastInputFiles=30
SET SMSLogFile=%DIR7Z%\SMSLog-%DATE:~-4%.csv
::===============================================================
IF NOT EXIST "%DIR7Z%." MKDIR "%DIR7Z%"
IF NOT EXIST "%DIRFLS%." MKDIR "%DIRFLS%"

:: Converting telnetd style SMS command file into MSG91 curl command files
for /f "Tokens=*" %%f IN ('DIR /b "%DIRFLS%\*.txt" 2^>nul') DO (
  for /f "tokens=3* delims=+= " %%A IN ('findstr /C:"sendsms" "%DIRFLS%\%%f"') DO ECHO curl -o "%DIRFLS%\%%f-%%A.log" http://api.msg91.com/api/sendhttp.php^?sender=%sender%  --data-urlencode route=%route% --data-urlencode mobiles=%%A --data-urlencode authkey=%Authkey% --data-urlencode country=%country% --data-urlencode message=%%B >"%DIRFLS%\%%f-%%A.cmd"
  REM Once sucessfully converting telnetd style SMS file into MSG91 curl command file, the original file isn't required.
  IF !ERRORLEVEL! == 0 DEL "%DIRFLS%\%%f" &&ECHO Deleted "%DIRFLS%\%%f"!
)

:: Find all curl cmd files and call to run
for /f "Tokens=*" %%g IN ('DIR /b "%DIRFLS%\*.cmd" 2^>nul') DO (
   ECHO Calling "%DIRFLS%\%%g"
   call "%DIRFLS%\%%g"
   REM If no errors, move files to log directory
   IF !ERRORLEVEL! == 0 MOVE "%DIRFLS%\%%g" "%DIR7Z%\%%g"  &CALL Send-Email "%DIR7Z%\%%g"
)

:: Find all curl cmd log (HTTP response) files to make CSV file of the entries and remove the original files
IF NOT EXIST "%SMSLogFile%" ECHO Date, Time, file name, cURL MSG91 Response >"%SMSLogFile%"
for /f "Tokens=*" %%g IN ('DIR /b "%DIRFLS%\*.log" 2^>nul') DO for /f "usebackq tokens=*" %%h IN ("%DIRFLS%\%%g") DO (
   ECHO !date:~-10!,!time!,%%g,%%h >>"%SMSLogFile%"
   DEL "%DIRFLS%\%%g"
)

:: Tidy up "Old curl command Files" based on how many new files we want to keep and Archive them per year.
for /f "tokens=* skip=%KeepLastInputFiles%" %%A IN ('dir /B /O-D "%DIR7Z%\*.cmd" 2^>nul') DO (
  REM Compress file
  "%~dp0\7z.exe" a -y "%DIR7Z%\MSG91.%DATE:~-4%.7z" "%DIR7Z%\%%A" >nul
  REM Remove original File
  IF !ERRORLEVEL! == 0 DEL "%DIR7Z%\%%A"
)
endlocal
