:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::                SMS via MSG91 service Loop                 ::
::                         V1.2                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2020/05/01                           ::
::                                                           ::
::          Makes use of 7z command line utilities           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@echo off
setlocal
:: Enter Configuration Parameters below;
::===============================================================

:: Renamed Storage location e.g. D:\Server\Share\AVI_Files\
SET DIRFLS=D:\server\Share\SMS\

:: Incoming Temp Storage location e.g. D:\Server\Share\AVI_Files\Temp
SET DIR7Z=D:\server\Share\SMS\Log\

:: ~30 second sleep Loop to reduce hard drive hammering if more frequent. (Empty to disable Loop)
SET LoopSleepSeconds=20
:: Number of days to keep log files
SET OutputLogFiles=30

::===============================================================
:: SETUP Parameters needed
IF NOT EXIST "%~dp0log\." mkdir "%~dp0log"
ECHO %TIME% SMS MSG91 Start| "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"
:Main_Loop
:: Run One Of These...
cd /d "%~dp0"
:: Run the Telnetd Process for Sending SMS from the WPU
CALL "%~dp0SMS-MSG91.bat"  | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"

:: Tidy up Old Log Files based on how many files we want to keep.
for /f "tokens=* skip=%OutputLogFiles%" %%A IN ('dir /B /O-D "%~dp0log\LOG.*.log"') DO DEL "%~dp0log\%%A"

:: Repeat loop from here.
IF DEFINED LoopSleepSeconds ECHO %TIME% Waiting %LoopSleepSeconds% Seconds... | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log" & (IF EXIST %~dp0choice.exe (%~dp0Choice.exe /N /T:Y,%LoopSleepSeconds%) else (choice /N /D Y /T %LoopSleepSeconds%)) & GOTO Main_Loop
endlocal
