:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::            Create Scheduled Task Batch Script             ::
::                         V3.3                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2017/09/21                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@ECHO OFF
setlocal
:: Version of Windows Detection
for /f "tokens=2 delims=][" %%A in ('ver^|find "Windows"') DO for /f "tokens=2,3,4 delims=. " %%I in ("%%A") DO IF "%%I"=="5" (SET winVER=XP) ELSE (SET winVER=7)
:: Parent Folder Name Detection
SET RunBatch=%~nx0
SET RUNPATH=%~f0
SET RUNPATH=%RUNPATH: =#%
CALL :SHIFTVARS %RUNPATH:\= %
SET ParentFolder=%ParentFolder:#= %
:: Find *.cmd file to use largest as the main Scheduled Task Entry.
FOR /F "tokens=*" %%a in ('DIR /B /OS "%~dp0\*.cmd"') DO SET FILE=%%a
:: Creates Scheduled Task to Run Every 5 Mins
IF %winVER%.==7. schtasks /create /sc MINUTE /mo 5 /tn "TrackIQ\%ParentFolder%" /tr "'%~dp0%FILE%'" /ru System
IF %winVER%.==XP. schtasks /create /sc MINUTE /mo 5 /tn "%ParentFolder%" /tr "\"%~dp0%FILE%\"" /ru System
choice /N /D Y /T 10
endlocal
GOTO :EOF

:: Tests path variables to detect only parent folder.
:SHIFTVARS
SET ParentFolder=%1
SET RunBatchTest=%2
IF "%RunBatchTest%"=="%RunBatch%" GOTO :EOF
SHIFT
GOTO :SHIFTVARS
