:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::              Process Monitor Batch Script                 ::
::                         V3.1                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2024/06/27                           ::
::                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Process Monitor Expects that the Computer Runs in UTC/GMT & Australian regional Settings (Otherwise This affects the Directory Structure created)
@ECHO OFF

:: Parse Variables (from configuration "INI" File)
IF NOT DEFINED basedir SET basedir=d:\server
IF NOT DEFINED trainsdirname SET trainsdirname=trains
IF NOT DEFINED matlabflagfile SET matlabflagfile=DELETE_THIS_IF_ALL_IS_OK

IF NOT DEFINED launcherscript SET launcherscript=script.cmd
IF NOT DEFINED killbeforelaunch SET killbeforelaunch=false
IF NOT DEFINED monitoredprocess SET monitoredprocess=Matlab.exe
IF NOT DEFINED monitoredfile SET monitoredfile=system_status.htm

IF NOT DEFINED graceperiodseconds SET graceperiodseconds=5
IF NOT DEFINED hangtimeoutsecs SET hangtimeoutsecs=600

IF NOT DEFINED PMOutputLogFiles SET PMOutputLogFiles=30


:: Internal Use in "INI" File
IF NOT DEFINED MonitorIntervalSecs SET MonitorIntervalSecs=10
IF NOT DEFINED PMRebootCMD SET PMRebootCMD=shutdown -r -f -t 30
IF NOT DEFINED PMRebootOnCountOf SET PMRebootOnCountOf=5


VERIFY OTHER 2>nul
SETLOCAL ENABLEEXTENSIONS ENABLEDELAYEDEXPANSION
IF ERRORLEVEL 1 CALL :ERRORSETLOCAL
REM Define Log File 
SET LOGFILE=%~dp0log\%monitoredprocess:~0,-4%.%DATE:/=-%.%~n0.log


CALL "%~dp0mkmessages.cmd" PMStart 
for /f "tokens=1 delims=." %%A IN ("%launcherscript%") DO IF EXIST "%~dp0\%%A.AllMsgHistory.cmd" START /min /low CMD /C "%~dp0%%A.AllMsgHistory.cmd" PMStart
IF NOT EXIST %basedir:~0,3%. CALL :ERRORBASEDIR
:: Create Default Directory Structure
IF NOT EXIST %basedir%\. mkdir %basedir%
IF NOT EXIST %basedir%\auxiliary\. mkdir %basedir%\auxiliary
IF NOT EXIST %basedir%\auxiliary\APC\. mkdir %basedir%\auxiliary\APC
IF NOT EXIST %basedir%\pointers\. mkdir %basedir%\pointers
IF NOT EXIST %basedir%\pointers\alarms\. mkdir %basedir%\pointers\alarms
IF NOT EXIST %basedir%\pointers\messages\. mkdir %basedir%\pointers\messages
IF NOT EXIST %basedir%\pointers\warnings\. mkdir %basedir%\pointers\warnings
IF NOT EXIST %basedir%\pointers\Talarms\. mkdir %basedir%\pointers\Talarms
IF NOT EXIST %basedir%\pointers\Tmessages\. mkdir %basedir%\pointers\Tmessages
IF NOT EXIST %basedir%\pointers\Twarnings\. mkdir %basedir%\pointers\Twarnings
IF NOT EXIST %basedir%\%trainsdirname%\. mkdir %basedir%\%trainsdirname%
IF NOT EXIST %basedir%\Share\. mkdir %basedir%\Share
:: Create Supported Directory Strucutre
IF NOT EXIST %~dp0..\Deploy\. mkdir %~dp0..\Deploy
IF NOT EXIST %~dp0..\Superseded\. mkdir %~dp0..\Superseded
:: Create Windows Network Share
REM Found this to be causing a blocking prompt to continue.
REM net share share-%basedir:~0,1%=%basedir%\Share /GRANT:everyone,FULL
:: Create file to Prevent HTML directory Indexing
SET FILE=%basedir%\index.html
IF NOT EXIST %FILE% CALL :IndexBlock
SET FILE=%basedir%\pointers\index.html
IF NOT EXIST %FILE% CALL :IndexBlock
:: Create Blank All Message History File
SET FILE=%basedir%\auxiliary\AllMsgs_history.htm
IF NOT EXIST %FILE% CALL :BlankAllMessageHistory
SET FILE=%basedir%\auxiliary\%monitoredfile%
:: Make a Log of the Previous monitored file
IF EXIST "%FILE%" type "%FILE%" >>"%basedir%\auxiliary\startupPM%monitoredfile%"
:: Create Blank System Status File
IF NOT EXIST %FILE% CALL :SystemStatus
SET FILE=
for /f "skip=2 tokens=4,* delims=x " %%A in ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\PowerShell\1" /v Install 2^>nul') DO @SET PowerShell=%%A
IF NOT 1.==%PowerShell%. (
:: Auto Select Date output format "Mon 29/06/2015" or "29/06/2015"
for /f "tokens=1,2,3,4 delims=/.: " %%A IN ("%DATE%") DO SET /A DATEANSWER=%%A+100
IF "100" == "!DATEANSWER!" (SET DTTKNS=2,3,4) ELSE (SET DTTKNS=1,2,3)
SET DATEANSWER=
IF NOT DEFINED DTTKNS SET DTTKNS=2,3,4
)
:: Clear this variable just in case a new cmd session was not used.
SET monitoredfileTS=
:: Start Hung Counter at Zero
SET PMHUNGCount=0
:: Detect the code page in use for translation (do each call, so that it can be tested in multiple languages quickly)
for /f "tokens=2 delims=:" %%A IN ('chcp') DO SET PMcp=%%A
SET PMMKDIR=0
:WorkingDIRFlag
REM Define Log File to use within this loop.
SET LOGFILE=%~dp0log\%monitoredprocess:~0,-4%.%DATE:/=-%.%~n0.log
SET WorkingDirectory=
CALL "%~dp0mkmessages.cmd" PMWorkDir 
:: Create Date and Time DIR %%C\%%B%%A\%%D%%E%%F\ Flag file... If Exist, try a New Date / Time... (Hence never re-use a Train Directory.)
IF "1"=="%PowerShell%" (
  for /f %%A IN ('powershell Get-Date -date ^(Get-Date^)-uformat %%Y\%%m%%d\%%H%%M%%S') DO SET WorkingDirectory=%basedir%\%trainsdirname%\%%A
) ELSE (  
  for /f "tokens=1,2,3 delims=/.: " %%D IN ("%TIME%") DO SET /A DIRTIME=10000000+10%%D%%E%%F
  for /f "tokens=%DTTKNS% delims=/.: " %%A IN ("%DATE%") DO SET WorkingDirectory=%basedir%\%trainsdirname%\%%C\%%B%%A\!DIRTIME:~-6!
  IF %PMcp%. == 936. for /f "tokens=%DTTKNS% delims=/.: " %%A IN ("%DATE%") DO SET WorkingDirectory=%basedir%\%trainsdirname%\%%A\%%B%%C\!DIRTIME:~-6!
)
IF EXIST %WorkingDirectory%  (GOTO :WorkingDIRFlag) ELSE (MKDIR %WorkingDirectory% &CD /D %WorkingDirectory% & ECHO. 2>%WorkingDirectory%\%matlabflagfile%)

CALL "%~dp0mkmessages.cmd" PMWorkDirNow 

:: Tidy up Old Log Files based on how many files we want to keep.
for /f "tokens=* skip=%PMOutputLogFiles%" %%A IN ('dir /B /O-D "%~dp0log\%monitoredprocess:~0,-4%.*.log"') DO DEL "%~dp0log\%%A"

:: This will kill any matching "monitoredprocess" regardless of how it was launched. (Using Image Name (file Name))
IF "%killbeforelaunch%"=="true" CALL "%~dp0mkmessages.cmd" PMKill 
IF "%killbeforelaunch%"=="true" taskkill /F /IM %monitoredprocess% >> "%LOGFILE%"

CALL "%~dp0mkmessages.cmd" PMGrace 
:: Put in Delay "graceperiodseconds"
CALL :RUNDELAY %graceperiodseconds%
:: IF NOT "%graceperiodseconds%"=="0" CALL :RUNDELAY %graceperiodseconds%

:: Keep Track of Launched Time of the Script (also equal to the start of the "monitored file" timeout)
for /f "tokens=1,2,3,4 delims=:. " %%A IN ("%TIME%") DO SET /A monitoredfileSecs=%%A * 360000 + (1%%B-100)*6000 + (1%%C-100) *100 + (1%%D-100)
:: Create Unique ID for launched Script used to Identify the process later.
SET CMDLINEID=%DATE%-%TIME%-%RANDOM%-%monitoredfileSecs%
SET CMDLINEID=%CMDLINEID: =_%
:: Run the "launcherscript" command with unique ID
CALL "%~dp0mkmessages.cmd" PMScript 
Start "PM-%monitoredprocess:~0,-4%" /MIN /I "%WINDIR%\System32\cmd.exe" /C "%~dp0\%launcherscript%" %CMDLINEID%
SET launcherscriptPID=

:: Get PID of the Launcher Script
for /f "tokens=5" %%A IN ('wmic process where name^="cmd.exe" get CommandLine^, ProcessID ^|FINDSTR "%CMDLINEID%"') DO IF NOT "%%A"=="where" SET launcherscriptPID=%%A
CALL "%~dp0mkmessages.cmd" PMScriptPID 

SET NEXTSTEP=:Checkmonitoredfile
:Checkmonitoredfile
:: Check for the monitoredfile status
CALL :RUNDELAY %MonitorIntervalSecs%
:: Get the Time
for /f "tokens=1,2,3,4 delims=:. " %%A IN ("%TIME%") DO SET /A HUNDOFSECONDS=%%A * 360000 + (1%%B-100)*6000 + (1%%C-100) *100 + (1%%D-100)
:: Get the file Time Stamp, Works regardless of regional settings. Uses First three parameters of DIR command (3rd parameter could file size or AM,PM)
for /F "tokens=1,2,3* delims= " %%A in ('dir /TW %basedir%\auxiliary\%monitoredfile%^|findstr "%monitoredfile%"') DO SET monitoredfileTST=%%A_%%B.%%C
CALL "%~dp0mkmessages.cmd" PMTimeStamp 
IF NOT DEFINED monitoredfileTS SET monitoredfileTS=%monitoredfileTST%

:: Add the seconds that the file was last updated with the timeout
SET /A monitoredfileTimeOutSeconds=%monitoredfileSecs% + %hangtimeoutsecs%*100
IF "%monitoredfileTST%"=="%monitoredfileTS%" (
    :: File TimeStamp Not Updated Need to check if the timeout has expired. Consider that the passing of a day will result in a time that was higher than current time (Add one day) - IF NEWTIME is Less than OLD TIME (monitored file) ADD a DAY of TIME to NEWTIME
    IF %HUNDOFSECONDS% LSS %monitoredfileSecs% SET /A HUNDOFSECONDS=%HUNDOFSECONDS% + 8640000
    :: IF the current time is Gereater than the calculated monitored file time plus timeout Start killing things.
    IF !HUNDOFSECONDS! GTR %monitoredfileTimeOutSeconds% CALL :KILLProcess
) ELSE (
    SET monitoredfileTS=%monitoredfileTST%
    SET monitoredfileSecs=%HUNDOFSECONDS%
)
:: Check If Script has Exited Cleanly.
IF NOT EXIST %matlabflagfile% CALL :NormalExitMsg

GOTO %NEXTSTEP%
:: Catch all Exit line.
ENDLOCAL
GOTO :EoF




:: Sub Routines
:RUNDELAY
SET RUNDELAYseconds=%1
IF NOT DEFINED RUNDELAYseconds exit /b
IF %RUNDELAYseconds%==0  exit /b
IF EXIST %windir%\system32\choice.exe (choice /N /C YN /D Y /T %RUNDELAYseconds%) else (ping -n %RUNDELAYseconds% localhost &ping -n 2 localhost)
exit /b

:: Normal Program exit loop
:NormalExitMsg
CALL "%~dp0mkmessages.cmd" PMExitOK 
:: Reset Hung Session Counter
SET PMHUNGCount=0
SET NEXTSTEP=:WorkingDIRFlag
exit /b

:: Find the Unique Commandline Process ID
:KILLProcess
:: Determine if the Process had exited without removing the flag file OR is still running but not updating the monitored file time stamp by finding the PID of Script
CALL "%~dp0mkmessages.cmd" PMScriptPIDCheck 
SET launcherscriptPIDtest=
for /F "skip=1 tokens=2 delims=," %%A IN ('tasklist /FI "PID eq %launcherscriptPID%" /FO csv') DO SET launcherscriptPIDtest=%%A
:: If no process ID found, nothing to kill
IF NOT DEFINED launcherscriptPIDtest CALL :ERRORKILLProcessSTALL
:: If Process ID found, it needs to be killed
IF DEFINED launcherscriptPIDtest CALL :ERRORKILLProcessHUNG
exit /b

:ERRORKILLProcessSTALL
CALL "%~dp0mkmessages.cmd" PMExitSTALL 
for /f "tokens=1 delims=." %%A IN ("%launcherscript%") DO IF EXIST "%~dp0\%%A.AllMsgHistory.cmd" START /min /low CMD /C "%~dp0%%A.AllMsgHistory.cmd" ERRORKILLProcessSTALL
SET NEXTSTEP=:WorkingDIRFlag
exit /b


:: Error output Section
:ERRORKILLProcessHUNG
:: Update counter of repeat Hung Sessions
SET /a PMHUNGCount= %PMHUNGCount% +1
IF %PMRebootOnCountOf%.==%PMHUNGCount%. CALL :PMHUNGCountExceeded
CALL "%~dp0mkmessages.cmd" PMExitHUNG 
for /f "tokens=1 delims=." %%A IN ("%launcherscript%") DO IF EXIST "%~dp0\%%A.AllMsgHistory.cmd" START /min /low CMD /C  "%~dp0%%A.AllMsgHistory.cmd" ERRORKILLProcessHUNG
:: Log a list of all running processes Just in case.
tasklist /V /FI "SESSION eq 0" >> "%LOGFILE%"
tasklist /V /FI "SESSION eq 1" >> "%LOGFILE%"
:: Find all child (not grand children) processes of the previously identified Process ID and kill them all.
CALL "%~dp0mkmessages.cmd" PMTerminating 
for /f "skip=1 tokens=2" %%A IN ('wmic process where parentProcessID^="%launcherscriptPID%" get processid^, name') DO @taskkill /F /FI "PID eq %%A" >> "%LOGFILE%"
:: Do I kill the script also, or just trust that it will complete/close on it's own? - might depend on the tasks after the hung process.
taskkill /F /FI "PID eq %launcherscriptPID%" >> "%LOGFILE%"
CALL "%~dp0mkmessages.cmd" PMTerminatingDone 
SET monitoredfileSecs=%HUNDOFSECONDS%
SET NEXTSTEP=:WorkingDIRFlag
exit /b

:PMHUNGCountExceeded
CALL "%~dp0mkmessages.cmd" PMHUNGCountExceeded 
:: for /f "tokens=1 delims=." %%A IN ("%launcherscript%") DO IF EXIST "%~dp0\%%A.AllMsgHistory.cmd" START /min /low CMD /C  "%~dp0%%A.AllMsgHistory.cmd" ERRORKILLProcessREBOOT
Start "PM-PMHUNGCountExceeded" /MIN /I "%WINDIR%\System32\cmd.exe" /C %PMRebootCMD%
pause
exit

:ERRORBASEDIR
CALL "%~dp0mkmessages.cmd" PMDirFail 
pause
exit

:ERRORSETLOCAL
CALL "%~dp0mkmessages.cmd" PMCMDFail 
pause
exit

:: Creating Files Section

:SystemStatus
ECHO ^<meta http-equiv="refresh" content="15;"^> >%FILE%
ECHO ^<html^>^<body^>^<TABLE Border="1" Cellpadding="5" Cellspacing="1" Align="center"^> >>%FILE%
ECHO ^<TR^> ^<TH^>Time^</TH^> ^<TH^>Mode^</TH^> ^<TH^>Data Acquisition^</TH^> ^<TH^>Tag Reader^</TH^> >>%FILE%
ECHO ^<TR Align="center"^> ^<TD^>01-Jan-2003 00:00^</TD^> ^<TD^>Awaiting Analysis Software^</TD^> ^<TD^> ^</TD^> ^<TD^>^<font color="red"^>^</font^> ^<BR^> ^<font color="red"^>^</font^>^</TD^> >>%FILE%
ECHO ^</TABLE^>^</body^>^</html^> >>%FILE%
exit /b

:IndexBlock
ECHO ^<HTML^>^<HEAD^>^<TITLE^>Not allowed^</TITLE^>^</HEAD^>^<BODY BGCOLOR=#EEEEEE^> >>%FILE%
ECHO ^<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 COLS=3 WIDTH="100%%"^> >>%FILE%
ECHO ^<TR^>^<TD VALIGN=TOP WIDTH="150"^>^<A HREF="/" target="_top"^>^<IMG SRC="/Images/htab.gif" BORDER=0 ^>Home page^</A^>^</TD^> >>%FILE%
ECHO ^<TD WIDTH="20"^>^</TD^>^<TD VALIGN=TOP^>^<CENTER^>^<H1^>Access Denied^</H1^> >>%FILE%
ECHO ^<P^>^<I^>Please press your browser "Back" button^</I^>^</P^>^</CENTER^> >>%FILE%
ECHO ^<P^>^<HR^>^<P^>You do not have permission to access the file or service you requested.^<P^>^<HR^>^</TR^> >>%FILE%
ECHO ^</TABLE^>^</BODY^>^</HTML^> >>%FILE%
exit /b

:BlankAllMessageHistory
ECHO ^<html^>^<body^>^<TABLE Border="1" Cellpadding="5" Cellspacing="1" Align="center"^> >%FILE%
ECHO ^<TR^> ^<TH^>Time^</TH^> ^<TH^>Prefix^</TH^> ^<TH^>Message^</TH^> >>%FILE%
ECHO ^</TABLE^>^</body^>^</html^> >>%FILE%
exit /b
