:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::           Re Analysis Train ID Batch Script               ::
::                         V1.0                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2024/07/10                           ::
::                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@ECHO OFF
IF NOT "%~1"=="" SET VEHICLEID=%~1
IF NOT DEFINED VEHICLEID SET VEHICLEID=dlrow 07734
IF NOT "%~2"=="" SET STARTYEAR=%~2
IF NOT DEFINED STARTYEAR SET STARTYEAR=2024
IF NOT "%~3"=="" SET STARTMONTH=%~3
IF NOT DEFINED STARTMONTH SET STARTMONTH=7
IF NOT "%~4"=="" SET STARTDAY=%~4
IF NOT DEFINED STARTDAY SET STARTDAY=10

SET GapBetweenTrains=

SET Data=D:\Server

SET BackupT94=YES

SET LOGFILE=%~dp0Logs\%~n0%~1.

rem  runs run_reports for a specified period
rem  Usage:     run_run_reports year dir_strt dir_end
rem  Example:   run_run_reports 2002 0501 0531
rem  Usage with extended arguments: run_run_reports year dir_strt dir_end rerunhndlwhlflag reanatvectflag toffshours
rem  the default for the flags is false and for the time offset is 0
rem  Example:                       run_run_reports 2002 0501 0531 false true 0

rem  temporarily extend path
SET MCR_CACHE_ROOT=C:\TrackIQ\WCM
SET PATH=%MCR_CACHE_ROOT%;%PATH%



IF "%~1"=="" CALL :TEE "Usage, 'Script' 'VEHICLEID' START-YEAR START-MONTH START-DAY"
IF "%~1"=="" CALL :TEE "Usage, ''%0'' ''%VEHICLEID%'' %STARTYEAR% %STARTMONTH% %STARTDAY%"


IF EXIST "%Data%\trains\." (
   CD /d "%Data%\trains"
) ELSE (
  CALL :TEE "Exiting, Folder not Found: %Data%\trains"&exit /b
)


CALL :TEE "Finding '%VEHICLEID%' from %STARTYEAR%\%STARTMONTH%%STARTDAY%"
for /f "tokens=*" %%A in ('dir /b /ad') DO for /l %%B in (%STARTYEAR%,1,%DATE:~-4%) DO CALL :DATEMONTH "%%A" %%B

cd /d "%~dp0"
exit/b

:DATEMONTH
if "%2"==="" exit /b
for /l %%C in (%STARTMONTH%,1,12) DO CALL :DATEMONTHDAY %1 %2 %%C
exit/b

:DATEMONTHDAY
if "%3"==="" exit /b
SET /A NOWMONTH=%3 + 100
IF %STARTMONTH%==%3 (
   for /l %%C in (%STARTDAY%,1,31) DO CALL :FINDVEHICLE %1 %2 %NOWMONTH:~-2% %%C
) ELSE (
   for /l %%C in (1,1,31) DO CALL :FINDVEHICLE %1 %2 %NOWMONTH:~-2% %%C
)
exit/b

:FINDVEHICLE
if "%4"==="" exit /b
SET Systemfolder=%~1
SET Year=%2
SET /A NOWDAY=%4 + 100
IF EXIST %Data%\trains\%2\%3%NOWDAY:~-2%\. CALL :TEE "%~1 - %2 - %3 - %NOWDAY:~-2%"
IF EXIST %Data%\trains\%2\%3%NOWDAY:~-2%\. for /f "tokens=*" %%E in ('findstr /s /m /c:"%VEHICLEID%"  "%Data%\trains\%2\%3%NOWDAY:~-2%\*.tab"') DO CALL :MOVEF1 "%%~dpE"
exit/b

:MOVEF1
cd /d "%Data%"
CALL :TEE "%~1 %CD%"
SET BuildDIR=%~1
CALL :BuildDIR %BuildDIR:\= %
IF DEFINED GapBetweenTrains timeout /t %GapBetweenTrains%
exit /b

:BuildDIR
cd /d "%Data%\%3\%4"
for /f %%D in ('dir /b %5\%6\*.tag') do @MOVE /Y %Data%\%3\%4\%5\%6\%%D %Data%\%3\%4\%5\%6\%%D.bak
timeout /t 1
%MCR_CACHE_ROOT%\railwcm.exe run_reports %5 %5 false false 0 %6 %6
IF EXIST *.tag (
   ECHO. 2>%Data%\trainlist\%4_%5_%6
) ELSE (
   for /f %%D in ('dir /b %5\%6\*.bak') do @MOVE %Data%\%3\%4\%5\%6\%%D %Data%\%3\%4\%5\%6\%%~nD
)
exit /b

:TEE
IF NOT EXIST %~dp0Logs mkdir %~dp0Logs
ECHO %TIME% %~1>> "%LOGFILE%%DATE:/=-%.log"
ECHO %TIME% %~1
exit /b