@echo off
rem  mkTsJWDScsv %SiteAcronym%
rem  does the following:
rem     Concatenate TRNTBL and AXLTBL csv files into UPRR file format ABD-SSSST-YYYYMMDD_HHMMSS.csv
rem     where YYYYMMDD_HHMMSS represents the timestamp extracted from the TRNTBL csv filename with SS set to 00
rem
rem  NOTE:  Delayed Environment Variable Expansion has to be enabled!
rem
rem  Example:
rem        cmd /v:on /c mkTsJWDScsv GOTH1

if exist TRNTBL_*.csv (
   @echo on
   for /f "usebackq tokens=2-6 delims=_.-" %%a in (`dir TRNTBL_*.csv /b`) do set tstmp=%%a%%b%%c_%%d%%e00

   if exist AXLTBL_*.csv (
      type TRNTBL_*.csv > ABD-%1-!tstmp!.csv
      type AXLTBL_*.csv >> ABD-%1-!tstmp!.csv
      echo Done
   ) else (
      echo Cannot find AXLTBL_*.csv, therefore no files were generated
   )
   @echo off
) else (
   echo Cannot find TRNTBL_*.csv, therefore no files were generated
)
