:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::           Re Analysis Train ID Batch Script               ::
::                         V1.0                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2024/07/10                           ::
::                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@ECHO OFF
IF NOT "%~1"=="" SET VEHICLEID=%~1
IF NOT DEFINED VEHICLEID SET VEHICLEID=93804812
IF NOT "%~2"=="" SET STARTYEAR=%~2
IF NOT DEFINED STARTYEAR SET STARTYEAR=2024
IF NOT "%~3"=="" SET STARTMONTH=%~3
IF NOT DEFINED STARTMONTH SET STARTMONTH=4
IF NOT "%~4"=="" SET STARTDAY=%~4
IF NOT DEFINED STARTDAY SET STARTDAY=26

SET GapBetweenTrains=

SET DataLinked=D:\serverLinked
SET Data=D:\Server


SET LOGFILE=%~dp0Logs\%~n0%~1.

IF "%~1"=="" CALL :TEE "Usage, 'Script' 'VEHICLEID' START-YEAR START-MONTH START-DAY"
IF "%~1"=="" CALL :TEE "Usage, ''%0'' ''%VEHICLEID%'' %STARTYEAR% %STARTMONTH% %STARTDAY%"

:: Create directory structure for selected train folders
IF NOT EXIST "%DataLinked%\." MKDIR "%DataLinked%"
IF NOT EXIST "%DataLinked%\trains\." MKDIR "%DataLinked%\trains"
IF NOT EXIST "%DataLinked%\trainlist\." mklink /D "%DataLinked%\trainlist" "%Data%\trainlist"
IF NOT EXIST "%DataLinked%\Share\." mklink /D "%DataLinked%\Share" "%Data%\Share"
IF NOT EXIST "%DataLinked%\auxiliary\." mklink /D "%DataLinked%\auxiliary" "%Data%\auxiliary"
IF NOT EXIST "%DataLinked%\pointers\." mklink /D "%DataLinked%\pointers" "%Data%\pointers"
IF EXIST "%Data%\TagLists\." IF NOT EXIST "%DataLinked%\TagLists\." mklink /D "%DataLinked%\TagLists" "%Data%\TagLists"
for /f %%A in ('dir /n /ad %Data%\WMAout*') do IF NOT EXIST "%DataLinked%\%%A\." mklink /D "%DataLinked%\%%A" "%Data%\%%A"
rem IF EXIST "%Data%\WMAout_T\." IF NOT EXIST "%DataLinked%\WMAout_T\." mklink /D "%DataLinked%\WMAout_T" "%Data%\WMAout_T"

CD /d "%Data%\trains"
CALL :TEE "Finding '%VEHICLEID%' from %STARTYEAR%\%STARTMONTH%%STARTDAY%"
for /f "tokens=*" %%A in ('dir /b /ad') DO for /l %%B in (%STARTYEAR%,1,%DATE:~-4%) DO CALL :DATEMONTH "%%A" %%B

rem for /l %%C in (1,1,31) DO CALL :FINDVEHICLE  %%A\trains\%%B\%STARTMONTH:~-2%??


cd /d "%~dp0"
exit/b

:DATEMONTH
if "%2"==="" exit /b
for /l %%C in (%STARTMONTH%,1,12) DO CALL :DATEMONTHDAY %1 %2 %%C
exit/b

:DATEMONTHDAY
if "%3"==="" exit /b
SET /A NOWMONTH=%3 + 100
IF %STARTMONTH%==%3 (
   for /l %%C in (%STARTDAY%,1,31) DO CALL :FINDVEHICLE %1 %2 %NOWMONTH:~-2% %%C
) ELSE (
   for /l %%C in (1,1,31) DO CALL :FINDVEHICLE %1 %2 %NOWMONTH:~-2% %%C
)
exit/b

:FINDVEHICLE
if "%4"==="" exit /b
SET Systemfolder=%~1
SET Year=%2
SET /A NOWDAY=%4 + 100
IF EXIST %Data%\trains\%2\%3%NOWDAY:~-2%\. CALL :TEE "%~1 - %2 - %3 - %NOWDAY:~-2%"
IF EXIST %Data%\trains\%2\%3%NOWDAY:~-2%\. for /f "tokens=*" %%E in ('findstr /s /m /c:"%VEHICLEID%"  "%Data%\trains\%2\%3%NOWDAY:~-2%\A*.csv"') DO CALL :MOVEF1 "%%~dpE"
exit/b

:MOVEF1
cd /d "%DataLinked%"
CALL :TEE "%~1 %CD%"
SET BuildDIR=%~1
CALL :BuildDIR %BuildDIR:\= %
REM for /f "tokens=* delims=\" %%F in ("%~1") DO CALL :BuildDIR %%F
REM COPY "%~1*.*" .
cd /d %Data%
IF DEFINED GapBetweenTrains timeout /t %GapBetweenTrains%
exit /b

:BuildDIR
IF NOT EXIST "%DataLinked%\%3\." mkdir "%DataLinked%\%3" 
IF NOT EXIST "%DataLinked%\%3\%4\." mkdir "%DataLinked%\%3\%4"
IF NOT EXIST "%DataLinked%\%3\%4\%5\." mkdir "%DataLinked%\%3\%4\%5"
IF NOT EXIST "%DataLinked%\%3\%4\%5\%6\." mklink /D "%DataLinked%\%3\%4\%5\%6" "%Data%\%3\%4\%5\%6" &CALL :TEE "Linked %3\%4\%5\%6"
exit /b

:TEE
IF NOT EXIST %~dp0Logs mkdir %~dp0Logs
ECHO %TIME% %~1>> "%LOGFILE%%DATE:/=-%.log"
ECHO %TIME% %~1
exit /b
