:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::              Process Monitor Batch Script                 ::
::                         V3.2                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2024/06/27                           ::
::                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@ECHO OFF
:: A Command to change the current directory to the directory containing the running batch file.
CD /D "%~dp0"
:: When run from the Configuration Program, the variable TYPE is defined, hence no need to prompt for which shortcuts need to be made.
IF DEFINED TYPE GOTO Common
:: Pull Version Information From ProcessMon.bat
IF NOT DEFINED VER for /f "tokens=1* delims=V: " %%A IN ('findstr /c"::" /E ProcessMon.bat ^|Findstr V') DO SET VER=%%A
:: Next Section calculates the date of the last modified file and sets that as a variable for Display
IF NOT DEFINED FD FOR /F "tokens=* " %%A in ('dir /OD /b') DO SET FD=%%~tA
CALL "%~dp0mkmessages.cmd" INSTALLTitle

:Menu
SET CHC=Q
SET SLCTL=NO
CALL :CHO 0
CALL "%~dp0mkmessages.cmd" MENUTXT
for /F "tokens=1,2 delims=. " %%A IN ('DIR /b ProcessMon.*.bat') DO (
      CALL :CHO %%B %%B %MENUSYS%
)
ECHO.
CHOICE /N /c %CHC% /M "  %MENUEXIT%"
CALL :SELECTFC %SLCTL%
:: If Nothing to do, so END....
IF NO.==%FILE%. GOTO :EoF
SET TYPE=%FILE%
:Common
CALL "%~dp0mkmessages.cmd" SHORTCommon
REM Section only applicable to Windows 7+ and RailBAM and RailSQAD
REM IF NOT %winVER%. == XP. IF %TYPE%.==RailBAM. tzutil /s "UTC" &ECHO System Clock Changed to UTC
REM IF NOT %winVER%. == XP. IF %TYPE%.==RailSQAD. tzutil /s "UTC" &ECHO System Clock Changed to UTC

:: Clean up Old Wrong Location Start Links.
IF EXIST "%ALLUSERSPROFILE%\Start Menu\Programs\Startup\*Start.lnk" DEL /Q "%ALLUSERSPROFILE%\Start Menu\Programs\Startup\*Start.lnk"

CALL "%~dp0mkmessages.cmd" INSTALLShort
:: Creating TrackIQ Folder Shortcuts Based on TYPE which shortcuts to Install

:: Create StartUp Shortcut
IF EXIST "%USERPROFILE%\AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Startup\." (
:: If Windows 7+:
   PUSHD "%USERPROFILE%\AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Startup"
) ELSE (
:: If Windows XP:
   PUSHD "%USERPROFILE%\Start Menu\Programs\Startup"
)
:: ProcessMonitor
   %~dp0\mkshortcuts.vbs /target:"%~dp0ProcessMON.%TYPE%.bat" /shortcut:"%SHORTPMRun%" /Icon:"%~dp0TrackIQ.ico" /WorkingDIR:"%~dp0" /wstyle:"7"
:: Lock Screen FOR TADS or TPDS
   IF %SHORTDIR%.==TADS. %~dp0\mkshortcuts.vbs /target:"%~dp0LockScreen.bat" /shortcut:"LockScreen" /Icon:"%SystemRoot%\system32\SHELL32.dll,44" /WorkingDIR:"%~dp0" /wstyle:"7"
   IF %SHORTDIR%.==TPDS. %~dp0\mkshortcuts.vbs /target:"%~dp0LockScreen.bat" /shortcut:"LockScreen" /Icon:"%SystemRoot%\system32\SHELL32.dll,44" /WorkingDIR:"%~dp0" /wstyle:"7"
POPD

IF NOT EXIST "%~dp0log\." MKDIR "%~dp0log"
:: Create Desktop Shortcut
PUSHD "%ALLUSERSPROFILE%\Desktop"
:: Link to Trains Folder
   IF NOT %TYPE%.==RailCam. %~dp0\mkshortcuts.vbs /target:"%WINDIR%\explorer.exe" /params:"D:\server\trains" /shortcut:"%SHORTTrains%" /Icon:"%SystemRoot%\system32\SHELL32.dll,3"
   IF %TYPE%.==RailCam. %~dp0\mkshortcuts.vbs /target:"%WINDIR%\explorer.exe" /params:"E:\server\trains" /shortcut:"%SHORTTrains%" /Icon:"%SystemRoot%\system32\SHELL32.dll,3"
:: AllMsgs history file
   IF NOT %TYPE%.==RailCam. %~dp0mkshortcuts.vbs /target:"D:\server\auxiliary\AllMsgs_history.htm" /shortcut:"%TYPE% All Msgs history" /Icon:"%SystemRoot%\system32\SHELL32.dll,167"
   IF %TYPE%.==RailCam. %~dp0mkshortcuts.vbs /target:"E:\server\auxiliary\AllMsgs_history.htm" /shortcut:"%TYPE% All Msgs history" /Icon:"%SystemRoot%\system32\SHELL32.dll,167"
:: Process Monitor Log files
   %~dp0mkshortcuts.vbs /target:"%WINDIR%\explorer.exe" /params:"%~dp0log\" /shortcut:"%SHORTPMLOG%" /Icon:"%SystemRoot%\system32\SHELL32.dll,165"
:: Maintenance GUI for Processes that have an independant one.
   IF EXIST %~dp0%TYPE%.maint_setup.cmd %~dp0mkshortcuts.vbs /target:"%~dp0%TYPE%.maint_setup.cmd" /shortcut:"%TYPE%.maint_setup" /Icon:"%~dp0TrackIQ.ico" /WorkingDIR:"%~dp0"
:: Restart System shortcut
   %~dp0\mkshortcuts.vbs /target:"%WINDIR%\System32\shutdown.exe" /params:"-f" /params1:"-r" /params2:"-d" /params3:"p:4:1" /params4:"-t" /params5:"10" /shortcut:"%SHORTRESTART%" /Icon:"%SystemRoot%\system32\SHELL32.dll,27" /WorkingDIR:"%WINDIR%\System32\" /wstyle:"7"
IF NOT EXIST ".\Serial Terminal" MKDIR "Serial Terminal"
pushd "Serial Terminal"
:: Serial Port Terminal Sessions
reg query "HKLM\SOFTWARE\Microstar Laboratories\DAPcell\Server\Control" 2>nul >nul
IF %ERRORLEVEL%==0 SET DAPCell=Installed
   IF EXIST C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe IF DEFINED DAPCell (
            %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/C=1" /params1:"/BAUD=9600" /params2:"/W=TagReader_COM1" /shortcut:"Tag Reader Com1" /Icon:"C:\TrackIQ\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/C=2" /params1:"/BAUD=9600" /params2:"/W=TagReader_COM2" /shortcut:"Tag Reader Com2" /Icon:"C:\TrackIQ\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            REM IF NOT %TYPE%.==RailCAM. %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/C=3" /params1:"/BAUD=9600" /params2:"/W=TagReader_COM3" /shortcut:"Tag Reader Com3" /Icon:"C:\TrackIQ\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
        ) ELSE (
            %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.101:23/" /params2:"/W=TI1_Serial_Status_[1.101:23]" /shortcut:"TI1 Serial Status [1.101-23]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.101:5231/" /params2:"/W=TI1_Serial_Device_[1.101:5231]" /shortcut:"TI1 Serial Device [1.101-5231]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            IF %TYPE%.==WCM. (
                %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.101:5232/" /params2:"/W=TI1_Serial_Device_[1.101:5232]" /shortcut:"TI1 Serial Device [1.101-5232]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            )
            IF %TYPE%.==RailBAM. (
                %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.102:23/" /params2:"/W=TI2_Serial_Status_[1.102:23]" /shortcut:"TI2 Serial Status [1.102-23]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
                %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.102:5231/" /params2:"/W=TI2_Serial_Device_[1.102:5231]" /shortcut:"TI2 Serial Device [1.102-5231]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
                REM %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.102:5232/" /params2:"/W=TI2_Serial_Device_[1.102:5232]" /shortcut:"TI2 Serial Device [1.102-5232]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            )
       )
POPD
POPD
IF NOT EXIST "%ALLUSERSPROFILE%\Start Menu\Programs\%SHORTDIR%\." MKDIR "%ALLUSERSPROFILE%\Start Menu\Programs\%SHORTDIR%"
:: Create TrackIQ Shortcut
PUSHD "%ALLUSERSPROFILE%\Start Menu\Programs\%SHORTDIR%"
:: ProcessMonitor
   %~dp0mkshortcuts.vbs /target:"%~dp0ProcessMON.%TYPE%.bat" /shortcut:"%SHORTPMRun%" /Icon:"%~dp0TrackIQ.ico" /WorkingDIR:"%~dp0" /wstyle:"7"
:: Maintenance GUI for Processes that have an independant one.
   IF EXIST %~dp0%TYPE%.maint_setup.cmd %~dp0mkshortcuts.vbs /target:"%~dp0%TYPE%.maint_setup.cmd" /shortcut:"%TYPE%.maint_setup" /Icon:"%~dp0TrackIQ.ico" /WorkingDIR:"%~dp0"
:: Process Monitor Log files
   %~dp0mkshortcuts.vbs /target:"%WINDIR%\explorer.exe" /params:"%~dp0log\" /shortcut:"%SHORTPMLOG%" /Icon:"%SystemRoot%\system32\SHELL32.dll,165"
:: Link to Trains Folder
   %~dp0mkshortcuts.vbs /target:"%WINDIR%\explorer.exe" /params:"D:\server\trains" /shortcut:"%SHORTTrains%" /Icon:"%SystemRoot%\system32\SHELL32.dll,3"
:: Serial Port Terminal Sessions
   IF EXIST C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe IF DEFINED DAPCell (
            %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/C=1" /params1:"/BAUD=9600" /params2:"/W=TagReader_COM1" /shortcut:"Tag Reader Com1" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/C=2" /params1:"/BAUD=9600" /params2:"/W=TagReader_COM2" /shortcut:"Tag Reader Com2" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            REM %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/C=3" /params1:"/BAUD=9600" /params2:"/W=TagReader_COM3" /shortcut:"Tag Reader Com3" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
        ) ELSE (
            %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.101:23/" /params2:"/W=TI1_Serial_Status_[1.101:23]" /shortcut:"TI1 Serial Status [1.101-23]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.101:5231/" /params2:"/W=TI1_Serial_Device_[1.101:5231]" /shortcut:"TI1 Serial Device [1.101-5231]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            IF %TYPE%.==WCM. (
               %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.101:5232/" /params2:"/W=TI1_Serial_Device_[1.101:5232]" /shortcut:"TI1 Serial Device [1.101-5232]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            )
            IF %TYPE%.==RailBAM. (
                %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.102:23/" /params2:"/W=TI2_Serial_Status_[1.102:23]" /shortcut:"TI2 Serial Status [1.102-23]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
                %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.102:5231/" /params2:"/W=TI2_Serial_Device_[1.102:5231]" /shortcut:"TI2 Serial Device [1.102-5231]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
                REM %~dp0\mkshortcuts.vbs /target:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /params:"/t=1" /params1:"telnet://172.16.1.102:5232/" /params2:"/W=TI2_Serial_Device_[1.102:5232]" /shortcut:"TI2 Serial Device [1.102-5232]" /Icon:"C:\%SHORTDIR%\Tools\TeraTerm\ttermpro.exe" /WorkingDIR:"C:\%SHORTDIR%\Tools\TeraTerm\"
            )
       )
POPD

ECHO Adding the %TYPE% Console Window Parameters to the Registry For All Users
REG ADD HKU\.DEFAULT\Console /f /v QuickEdit /t REG_DWORD /d 0
REG ADD HKU\.DEFAULT\Console\%TYPE% /f /v HistoryNoDup /t REG_DWORD /d 0
REG ADD HKU\.DEFAULT\Console\%TYPE% /f /v ScreenBufferSize /t REG_DWORD /d 196608123
REG ADD HKU\.DEFAULT\Console\%TYPE% /f /v WindowPosition /t REG_DWORD /d 26607632
REG ADD HKU\.DEFAULT\Console\%TYPE% /f /v WindowSize /t REG_DWORD /d 1638523

ECHO Adding the %TYPE% Console Window Parameters to the Registry for the Current User
REG ADD HKCU\Console /f /v QuickEdit /t REG_DWORD /d 0
REG ADD HKCU\Console\%TYPE% /f /v HistoryNoDup /t REG_DWORD /d 0
REG ADD HKCU\Console\%TYPE% /f /v ScreenBufferSize /t REG_DWORD /d 196608123
REG ADD HKCU\Console\%TYPE% /f /v WindowPosition /t REG_DWORD /d 26607632
REG ADD HKCU\Console\%TYPE% /f /v WindowSize /t REG_DWORD /d 1638523



ECHO Creating Folder Structure for Commissioning
IF NOT EXIST C:\Commissioning\FAT\. MKDIR C:\Commissioning\FAT
cd.>"C:\Commissioning\FAT\Copy train timestamp folder here and add extention of test e.g. _SnsrTst"
IF NOT EXIST C:\Commissioning\SIT\. MKDIR C:\Commissioning\SIT
cd.>"C:\Commissioning\SIT\Copy train timestamp folder here and add extention of test e.g. _SnsrTst"
IF NOT EXIST C:\Commissioning\CHK\. MKDIR C:\Commissioning\CHK
cd.>"C:\Commissioning\CHK\Copy train timestamp folder here and add extention of test e.g. _SnsrTst"
IF NOT EXIST C:\Commissioning\Updates\. MKDIR C:\Commissioning\Updates
cd.>"C:\Commissioning\Updates\Follow Document 51R-05-5656-TNT-239619-... .Site Software Installation or Update"

CALL :WPUpowercfg

CALL :DefenderExclusions C:\TrackIQ
CALL :DefenderExclusions D:\server
CALL :DefenderExclusions E:\server
CALL :DefenderExclusions F:\server
CALL :DefenderExclusions G:\server

:: Create Windows Network Share
net share share-D=D:\server\Share /GRANT:everyone,FULL

:: Add Firewall Exception for Analysis Software
for /f "tokens=*" %%B in ('dir /b "C:\%SHORTDIR%\%TYPE%\*.exe"') DO CALL :FirewallAddApp "%%~fB" "%%~nB Analysis Software"

ECHO.
ECHO Configuting Gigabit Network settings
for /f "tokens=3 delims={}" %%A IN ('reg query HKLM\SYSTEM\CurrentControlSet\Control\Class\{4D36E972-E325-11CE-BFC1-08002BE10318}\') do @reg query HKLM\SYSTEM\CurrentControlSet\Control\Class\{4D36E972-E325-11CE-BFC1-08002BE10318}%%A\ /v DriverDesc 2>nul |findstr /c:"Connection"&&(
  reg add HKLM\SYSTEM\CurrentControlSet\Control\Class\{4D36E972-E325-11CE-BFC1-08002BE10318}%%A\ /v *JumboPacket /d 9014 /f
  reg add HKLM\SYSTEM\CurrentControlSet\Control\Class\{4D36E972-E325-11CE-BFC1-08002BE10318}%%A\ /v *ReceiveBuffers /d 2048 /f
  reg add HKLM\SYSTEM\CurrentControlSet\Control\Class\{4D36E972-E325-11CE-BFC1-08002BE10318}%%A\ /v *TransmitBuffers /d 2048 /f
  reg add HKLM\SYSTEM\CurrentControlSet\Control\Class\{4D36E972-E325-11CE-BFC1-08002BE10318}%%A\ /v PnPCapabilities /t REG_DWORD /d 24 /f
)

:: Local PC's Java Time Zone
REG query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v "DEMS_TIMEZONE" >nul
IF %ERRORLEVEL% == 0 (
    for /f "tokens=1,2,3" %%a in ('REG query "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /v "DEMS_TIMEZONE"') DO SET TIMEZONE=%%c
) ELSE (
    SET TIMEZONE=Australia/Adelaide
)
ECHO Enter Format As                               : Australia/Adelaide
ECHO The Current Java Time Zone Is                 : %TIMEZONE%
:TZRepeat
SET INPUT=
SET /p INPUT="Please Enter The Site's Time Zone             : "
:: Remove Spaces from User Input.
CALL :INPUTSPACE %INPUT%
:: IF NOT DEFINED INPUT SET INPUT=%TIMEZONE%
IF .==.%INPUT% SET INPUT=%TIMEZONE%
SET INPUT=%INPUT: =_%
SET JAVAEXE=
:: Find working Java runtime on the system
for /f "tokens=*" %%A IN ('dir /s /b "C:\Program Files\java.exe" 2^>nul') DO SET JAVAEXE=%%A
for /f "tokens=*" %%A IN ('dir /s /b "C:\Program Files (x86)\java.exe" 2^>nul') DO SET JAVAEXE=%%A
IF EXIST "%JAVAEXE%" "%JAVAEXE%" -cp %~dp0 validateTZ %INPUT% >%TEMP%\TZVALIDATE.TXT
IF EXIST %TEMP%\TZVALIDATE.TXT SET /P TZVALIDATE="" < %TEMP%\TZVALIDATE.TXT
IF EXIST %TEMP%\TZVALIDATE.TXT del %TEMP%\TZVALIDATE.TXT
IF true. == %TZVALIDATE%. ECHO Time Zone Is Now Set To                       : %INPUT%
:: Replace incorrect time zone with previous value
IF false. == %TZVALIDATE%. SET INPUT=%TIMEZONE%
IF false. == %TZVALIDATE%. ECHO Time Zone Entered was Invalid, Previous Entry : %INPUT% &GOTO TZRepeat
:: If variable not exist
IF . == %TZVALIDATE%.     ECHO A Java Error Occurred, Using your Entry       : %INPUT%
IF ERROR. == %TZVALIDATE%. ECHO A Script Error Occurred, Using your Entry     : %INPUT%

choice /T 5 /d y /n /m ""
:: Compatibility  with OLD MatLAB software code refers to for Timezone.
IF NOT EXIST "C:\Program Files\RailBAM\." MKDIR "C:\Program Files\RailBAM"
ECHO @javaw.exe -DEMS_TIMEZONE="%INPUT%" -version >"C:\Program Files\RailBAM\ProcessMonitor.BAT"
REG ADD "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Environment" /f /v "DEMS_TIMEZONE" /d %INPUT%
SET INPUT=
SET JAVAEXE=
SET TZVALIDATE=
SET TIMEZONE=
EXIT /B

:WPUpowercfg
ECHO Altering Power Configuration Settings

SET FILE=%temp%\Scheme_GUID.txt

ECHO Find the High performance Scheme_GUID (Win 7)
powercfg -l|find "High performance" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfg=%%b
ECHO Set the High performance Profile to Current.
IF NOT DEFINED powercfg exit /b
powercfg -s %powercfg%

ECHO Setting Require a password on wakeup to off
powercfg -q %powercfg%|FIND "Settings belonging to no subgroup" >%FILE%
FOR /F "eol=; tokens=2,3,4* delims=, " %%a IN (%FILE%) DO SET powercfgsub=%%b
powercfg -q %powercfg%|FIND "Require a password on wakeup" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfgid=%%b
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setacvalueindex %powercfg% %powercfgsub% %powercfgid% 0
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setdcvalueindex %powercfg% %powercfgsub% %powercfgid% 0

ECHO Setting Turn off hard disk after 360 minutes (6 hours)
powercfg -q %powercfg%|FIND "Hard disk" >%FILE%
FOR /F "eol=; tokens=2,3,4* delims=, " %%a IN (%FILE%) DO SET powercfgsub=%%b
powercfg -q %powercfg%|FIND "Turn off hard disk after" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfgid=%%b
:: Value is in Seconds
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setacvalueindex %powercfg% %powercfgsub% %powercfgid% 21600
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setdcvalueindex %powercfg% %powercfgsub% %powercfgid% 21600

ECHO Setting Sleep to Never
powercfg -q %powercfg%|FIND "(Sleep)" >%FILE%
FOR /F "eol=; tokens=2,3,4* delims=, " %%a IN (%FILE%) DO SET powercfgsub=%%b
powercfg -q %powercfg%|FIND "Sleep after" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfgid=%%b
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setacvalueindex %powercfg% %powercfgsub% %powercfgid% 0
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setdcvalueindex %powercfg% %powercfgsub% %powercfgid% 0
powercfg -q %powercfg%|FIND "Hibernate after" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfgid=%%b
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setacvalueindex %powercfg% %powercfgsub% %powercfgid% 0
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setdcvalueindex %powercfg% %powercfgsub% %powercfgid% 0

ECHO Setting USB selective suspend setting to disabled
powercfg -q %powercfg%|FIND "USB settings" >%FILE%
FOR /F "eol=; tokens=2,3,4* delims=, " %%a IN (%FILE%) DO SET powercfgsub=%%b
powercfg -q %powercfg%|FIND "USB selective suspend setting" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfgid=%%b
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setacvalueindex %powercfg% %powercfgsub% %powercfgid% 0
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setdcvalueindex %powercfg% %powercfgsub% %powercfgid% 0

ECHO Setting Link State Power Management to Disabled
powercfg -q %powercfg%|FIND "PCI Express" >%FILE%
FOR /F "eol=; tokens=2,3,4* delims=, " %%a IN (%FILE%) DO SET powercfgsub=%%b
powercfg -q %powercfg%|FIND "Link State Power Management" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfgid=%%b
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setacvalueindex %powercfg% %powercfgsub% %powercfgid% 0
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setdcvalueindex %powercfg% %powercfgsub% %powercfgid% 0

ECHO Setting Processor power management to 100% all the time
powercfg -q %powercfg%|FIND "Processor power management" >%FILE%
FOR /F "eol=; tokens=2,3,4* delims=, " %%a IN (%FILE%) DO SET powercfgsub=%%b
powercfg -q %powercfg%|FIND "Minimum processor state" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfgid=%%b
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setacvalueindex %powercfg% %powercfgsub% %powercfgid% 100
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setdcvalueindex %powercfg% %powercfgsub% %powercfgid% 100
powercfg -q %powercfg%|FIND "System cooling policy" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfgid=%%b
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setacvalueindex %powercfg% %powercfgsub% %powercfgid% 1
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setdcvalueindex %powercfg% %powercfgsub% %powercfgid% 1
powercfg -q %powercfg%|FIND "Maximum processor state" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfgid=%%b
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setacvalueindex %powercfg% %powercfgsub% %powercfgid% 100
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setdcvalueindex %powercfg% %powercfgsub% %powercfgid% 100

ECHO Setting Turn off Display to Never
powercfg -q %powercfg%|FIND "(Display)" >%FILE%
FOR /F "eol=; tokens=2,3,4* delims=, " %%a IN (%FILE%) DO SET powercfgsub=%%b
powercfg -q %powercfg%|FIND "Turn off display" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfgid=%%b
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setacvalueindex %powercfg% %powercfgsub% %powercfgid% 0
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setdcvalueindex %powercfg% %powercfgsub% %powercfgid% 0

ECHO Setting Power buttons and lid to Shutdown
powercfg -q %powercfg%|FIND "Power buttons" >%FILE%
FOR /F "eol=; tokens=2,3,4* delims=, " %%a IN (%FILE%) DO SET powercfgsub=%%b
powercfg -q %powercfg%|FIND "Start menu power button" >%FILE%
FOR /F "eol=; tokens=3,4,5* delims=, " %%a IN (%FILE%) DO SET powercfgid=%%b
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setacvalueindex %powercfg% %powercfgsub% %powercfgid% 2
IF DEFINED powercfgsub IF DEFINED powercfgid powercfg -setdcvalueindex %powercfg% %powercfgsub% %powercfgid% 2


powercfg -H off
:: Clean Up
del /q %FILE%
SET powercfg=
SET powercfgsub=
SET powercfgid=
exit /b

:DefenderExclusions
ECHO Adding %1 to Windows Defender Exclusions
powershell -inputformat none -outputformat none -NonInteractive -Command Add-MpPreference -ExclusionPath "%1"
exit /b

:FirewallAddApp
:: Format :FirewallAddApp %1(ProgramWithPath) %2(Name)
IF %1. == . exit /b
IF %2. == . exit /b
:: Clears the Current Error Level
verify >nul
IF NOT DEFINED winVER ECHO ERROR: Parameter winVER was not set! &exit /b
IF %winVER%. == XP. CALL :XPApp %1 %2
IF NOT %winVER%. == XP. CALL :SevenApp %1 %2
exit /b

:XPApp
netsh firewall add allowedprogram program=%1 name=%2 mode=ENABLE scope=ALL profile=ALL  >nul
SET /A ELS=%ELS%+%ERRORLEVEL%
exit /b

:SevenApp
for /F %%a IN ('netsh advfirewall firewall show rule "name=%2"') DO SET FWRL=%%a
IF %FWRL%. == No. (
    netsh advfirewall firewall add rule name=%2 dir=in action=allow program=%1 enable=yes protocol=any
    SET /A ELS=%ELS%+%ERRORLEVEL%
) >nul
IF %FWRL%. == Ok.. (
    netsh advfirewall firewall set rule name=%2 new program=%1
    SET /A ELS=%ELS%+%ERRORLEVEL%
) >nul
rem ECHO rule %3 added... %1=%2
exit /b

:INPUTSPACE
REM Simple Trick to Eliminate Spaces from User Entered Text.
SET INPUT=%*
exit /b

:SELECTFC
REM This Function uses the Error Level Number to select from the list of paramaters passed to it
IF %1. == . GOTO :EOF
for /L %%A IN (2,1,%ERRORLEVEL%) DO SHIFT
IF %1. == . (
   SET FILE=NO
) ELSE (
   SET FILE=%1
   IF %ERRORLEVEL%==0 SET SET FILE=NO
)
EXIT /B

:CHO
:: New Menu command
IF %1. == 0. SET /A MYCHOICE=0 - 1 & GOTO :EOF

:: If called without parameter, do nothing
IF %1. == . GOTO :EOF
:: If called without 2nd parameter, do nothing
IF %2. == . GOTO :EOF

SET /A MYCHOICE=%MYCHOICE% + 1
IF 10 GTR %MYCHOICE%  (
   SET CHO=%MYCHOICE%
) ELSE (
    IF %MYCHOICE% == 10 SET CHO=A
    IF %MYCHOICE% == 11 SET CHO=B
    IF %MYCHOICE% == 12 SET CHO=C
    IF %MYCHOICE% == 13 SET CHO=D
    IF %MYCHOICE% == 14 SET CHO=E
    IF %MYCHOICE% == 15 SET CHO=F
    IF %MYCHOICE% == 16 SET CHO=G
    REM H Reserved for Help
    IF %MYCHOICE% == 17 SET CHO=I
    IF %MYCHOICE% == 18 SET CHO=J
    IF %MYCHOICE% == 19 SET CHO=K
    IF %MYCHOICE% == 20 SET CHO=L
    IF %MYCHOICE% == 21 SET CHO=M
    IF %MYCHOICE% == 22 SET CHO=N
    IF %MYCHOICE% == 23 SET CHO=O
    REM P Reserved for Command Prompt
    REM Q Reserved for Quit
    REM R Reserved for Return
    REM S Reserved for Switch
    IF %MYCHOICE% == 24 SET CHO=T
    IF %MYCHOICE% == 25 SET CHO=U
    IF %MYCHOICE% == 26 SET CHO=V
    IF %MYCHOICE% == 27 SET CHO=W
    IF %MYCHOICE% == 28 SET CHO=X
    IF %MYCHOICE% == 39 SET CHO=Y
    IF %MYCHOICE% == 30 SET CHO=Z
    IF %MYCHOICE% GTR 30 SET CHO=! &ECHO   !- ! ! ! Choice Invalid ! ! !, too many options detected.
)

SET SLCTL=%SLCTL% %1
SET CHC=%CHC%%CHO%
SET INPUT=%*
:: Using SET's Built in Search and Replace Function
SET INPUT=%INPUT:"=_%
SET INPUT=%INPUT:+="%
:: This is to handle if the parameter is "Quoted " or un Quoted
for /F %%e IN ('ECHO %INPUT% ^|FIND /C "_"') DO (
    IF "%%e"=="0" (
        for /f "tokens=1* " %%A IN ("%INPUT%") DO ECHO   %CHO%- %%B
    ) ELSE (
        for /f "tokens=1* delims=_" %%A IN ("%INPUT%") DO ECHO   %CHO%-%%B
    )
)
SET INPUT=
exit /b