:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::              Java Timezone Updater Scripts                ::
::                         V2.2                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2022/10/04                           ::
::                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@echo off
:: Runs/Checks TZ Updater for the Full system.

:: A Command to change the current directory to the directory containing the running batch file.
CD /D "%~dp0"

:: Ensures required parameters are defined. (Default is Check only)
IF NOT DEFINED tzupdaterCMD SET tzupdaterCMD=-jar tzupdater.jar -t -v
IF NOT DEFINED ModeTXT SET ModeTXT=checking

for /F %%A IN ('DIR /OD /b  tzupdater*.zip') DO SET FILE=%%A
IF EXIST "C:\Program Files\7-Zip\7z.exe" (
  "C:\Program Files\7-Zip\7z.exe" e  -y %FILE% tzupdater.jar. *\tzupdater.jar -o.\ >nul
) ELSE (
  ECHO 7 Zip Not Found Can not Extract the latest version.
)

if NOT exist %~dp0tzupdater.jar (
   ECHO %~dp0tzupdater.jar not Found
   IF NOT %1. == . IF EXIST %windir%\system32\choice.exe (choice /N /C YN /D Y /T 5) else (ping -n 6 localhost)
   GOTO :EOF
)

:: Any system default Java installation
IF not defined ProgramFiles^(x86^) (
echo.
echo -------------- %ModeTXT% default java ------------------------------------------
java %tzupdaterCMD%
)

:: Java SDK Install (RailBAM 2003-2006 systems)
if exist "c:\java2sdk\bin\java.exe" (
   echo.
   echo ------ %ModeTXT% JAVA Found At: c:\java2sdk\bin\java.exe
   c:\java2sdk\bin\java %tzupdaterCMD%
)
IF NOT %1. == . IF NOT %1. == AUTO. GOTO :EOF

:: Program Files Java Path
for /f "tokens=*" %%A in ('dir /s /b "%ProgramFiles%\Java\java.exe" 2^>nul') DO (
   echo.
   echo ------ %ModeTXT% JAVA Found At: %%A
   echo.
   "%%A" %tzupdaterCMD%
)
IF DEFINED ProgramFiles(x86) for /f "tokens=*" %%A in ('dir /s /b "%ProgramFiles(x86)%\Java\java.exe" 2^>nul') DO (
   echo.
   echo ------ %ModeTXT% JAVA Found At: %%A
   echo.
   "%%A" %tzupdaterCMD%
)

:: Program Files MathWorks Path
for /f "tokens=*" %%A in ('dir /s /b "%ProgramFiles%\MathWorks\java.exe" 2^>nul') DO (
   echo.
   echo ------ %ModeTXT% JAVA Found At: %%A
   echo.
   "%%A" %tzupdaterCMD%
)
IF DEFINED ProgramFiles(x86) for /f "tokens=*" %%A in ('dir /s /b "%ProgramFiles(x86)%\MathWorks\java.exe" 2^>nul') DO (
   echo.
   echo ------ %ModeTXT% JAVA Found At: %%A
   echo.
   "%%A" %tzupdaterCMD%
)

:: Program Files MATLAB Path
for /f "tokens=*" %%A in ('dir /s /b "%ProgramFiles%\MATLAB\java.exe" 2^>nul') DO (
   echo.
   echo ------ %ModeTXT% JAVA Found At: %%A
   echo.
   "%%A" %tzupdaterCMD%
)
IF DEFINED ProgramFiles(x86) for /f "tokens=*" %%A in ('dir /s /b "%ProgramFiles(x86)%\MATLAB\java.exe" 2^>nul') DO (
   echo.
   echo ------ %ModeTXT% JAVA Found At: %%A
   echo.
   "%%A" %tzupdaterCMD%
)
:: Matlab MCR72 that requires a java.exe
if exist "C:\Program Files\MathWorks\MATLAB Component Runtime\v72\sys\java\jre\win32\jre1.5.0\bin\java.dll" (
      echo.
      echo ------ %ModeTXT% JAVA Found At: C:\Program Files\MathWorks\MATLAB Component Runtime\v72\sys\java\jre\win32\jre1.5.0\bin\java.exe
      echo ... temprarily copy java.exe to the jre
      copy .\java1.5.0.exe "C:\Program Files\MathWorks\MATLAB Component Runtime\v72\sys\java\jre\win32\jre1.5.0\bin\java.exe"
      "C:\Program Files\MathWorks\MATLAB Component Runtime\v72\sys\java\jre\win32\jre1.5.0\bin\java" %tzupdaterCMD%
      dir "C:\Program Files\MathWorks\MATLAB Component Runtime\v72\sys\java\jre\win32\jre1.5.0\bin\java.exe"
      echo ... removing copy java.exe to the jre
      del "C:\Program Files\MathWorks\MATLAB Component Runtime\v72\sys\java\jre\win32\jre1.5.0\bin\java.exe"
)

:: Wait to show the results
IF EXIST %windir%\system32\choice.exe (choice /N /C YN /D Y /T 5) else (ping -n 6 localhost)