/*
 * Decompiled with CFR 0.152.
 */
package tools.javazic;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tools.javazic.Main;
import tools.javazic.ZoneRec;
import tools.javazic.Zoneinfo;

class Zone {
    private String name;
    private List<ZoneRec> list;
    private static Set<String> targetZones;

    Zone(String string) {
        this.name = string;
        this.list = new ArrayList<ZoneRec>();
    }

    static void readZoneNames(String string) {
        Object object;
        if (string == null) {
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            object = new FileReader(string);
            bufferedReader = new BufferedReader((Reader)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Main.info("warning: can't open file: " + string);
            return;
        }
        targetZones = new HashSet<String>();
        try {
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)(object = ((String)object).trim())).length() == 0 || ((String)object).charAt(0) == '#' || targetZones.add((String)object)) continue;
                Main.warning("duplicated target zone name: " + (String)object);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Main.panic("IO error: " + iOException.getMessage());
        }
    }

    static boolean isTargetZone(String string) {
        if (targetZones == null) {
            return true;
        }
        return targetZones.contains(string);
    }

    static void addMET() {
        if (targetZones != null) {
            targetZones.add("MET");
        }
    }

    String getName() {
        return this.name;
    }

    void add(ZoneRec zoneRec) {
        this.list.add(zoneRec);
    }

    ZoneRec get(int n) {
        return this.list.get(n);
    }

    ZoneRec forYear(int n) {
        ZoneRec zoneRec = null;
        for (ZoneRec zoneRec2 : this.list) {
            if (!zoneRec2.hasUntil() || n > zoneRec2.getUntilYear()) break;
            zoneRec = zoneRec2;
        }
        return zoneRec == null ? this.get(this.list.size() - 1) : zoneRec;
    }

    int size() {
        return this.list.size();
    }

    void resolve(Zoneinfo zoneinfo) {
        for (int i = 0; i < this.list.size(); ++i) {
            ZoneRec zoneRec = this.list.get(i);
            zoneRec.resolve(zoneinfo);
        }
    }
}

