:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::                 FTP Sort Batch Script                     ::
::                         V2.0                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2020/04/06                           ::
::                                                           ::
::                Makes use of FTPSort.BAT                   ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
@echo off
setlocal
:: Enter Configuration Parameters below;
::===============================================================
:: ~30 second sleep Loop to reduce hard drive hammering if more frequent. (empty to disable Loop, i.e. run once and exit)
:: This depends on the data frequency and configuration of Scheduled Task.
SET LoopSleepSeconds=60

::===============================================================
:Main_Loop
CALL "%~dp0\FTPSort_DMZ.bat"

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Repeat loop from here.
IF DEFINED LoopSleepSeconds ECHO %DATE% %TIME% Waiting %LoopSleepSeconds% Seconds... & (IF EXIST %~dp0choice.exe (%~dp0Choice.exe /N /T:Y,%LoopSleepSeconds%) else (choice /N /D Y /T %LoopSleepSeconds%)) & GOTO Main_Loop
endlocal
