:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::                 FTP Sort Batch Script                     ::
::                         V4.0                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2019/02/03                           ::
::                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@ECHO OFF
:: ==================================================== Define Parameters ==================================================================
ECHO %TIME% Starting sorting files process...
:: ROOT Folder of FTP for incoming Files to be sorted. (Everything should be relative to this folder.)
REM SET FTPINCOMINGDIR=F:\FTP\AutoFTPut\OUTBOUND
SET FTPINCOMINGDIR=D:\SVN\RailTools\ServerScripts\FTP\OUTBOUND
:: Folder containing the FTP file sorting rules by filename: <Diagnostics Site ID>#<Site Acronym>#<Archive Y/N>#<Directory1>#<Directory2>#<Directory3># <Ignored, can be used as comments>
SET SORTRULESDIR=..\Sort_Rules
:: Temp Folder for sorting files so they can not be modified and are not locked.
SET FTPSORTDIR=..\TIQSORT
:: Fix Destination Folders
SET DIAGNOSTICSDIR=..\Diagnostics
SET ArchiveDIR=..\ZArchive\
:: =========================================================================================================================================
ECHO %TIME% Changing to FTP Download Directory.
CD /D "%FTPINCOMINGDIR%" ||goto :eof
ECHO %TIME% Check for Uploaded Files that are complete but didn't get renamed.
CALL %~dp0Recover
:: Create Default Directories (Otherwise steps may fail.)
IF NOT EXIST "%SORTRULESDIR%" MKDIR "%SORTRULESDIR%"
IF NOT EXIST "%FTPSORTDIR%" MKDIR "%FTPSORTDIR%"
IF NOT EXIST "%DIAGNOSTICSDIR%" MKDIR "%DIAGNOSTICSDIR%"
IF NOT EXIST "%ArchiveDIR%" MKDIR "%ArchiveDIR%"
:: Avoid file Locks or additional files added during processing by using a Sort Directory.
ECHO %TIME% MOVE RAR Files into Temp Sort Directory
:: Test if file is locked by updating the timestamp, If test ok, COPY to Destination
for /f "tokens=*" %%A IN ('DIR /b *.RAR 2^>nul') DO 2>nul (call;>>"%%A") && MOVE /Y "%%A" %FTPSORTDIR%
ECHO %TIME% MOVE 7z  Files into Temp Sort Directory
:: Test if file is locked by updating the timestamp, If test ok, COPY to Destination
for /f "tokens=*" %%A IN ('DIR /b *.7z 2^>nul') DO 2>nul (call;>>"%%A") && MOVE /Y "%%A" %FTPSORTDIR%
ECHO %TIME% Changing to Temp Sort Directory
cd "%FTPSORTDIR%"
ECHO %TIME% Running All Sorting Rules as defined in Download Directory: %SORTRULESDIR%
:: Scan all sorting rules from Directory and call sorting routine.
for /f "tokens=1,2,3,4,5,6,* delims=#" %%A in ('dir /b /a-d %SORTRULESDIR%') DO (
    SET SiteID=%%A
    SET SiteAcronm=%%B
    SET ARCHIVE=%%C
    SET DIR1=%%D
    SET DIR2=%%E
    SET DIR3=%%F
    CALL :SORTFILES
    SET SiteID=
    SET SiteAcronm=
    SET ARCHIVE=
    SET DIR1=
    SET DIR2=
    SET DIR3=
)
goto :eof

:SORTFILES
ECHO %TIME% Sorting %SiteID%
:: MOVE DIAGNOSTICS files if required parameters are DEFINED and _XML.* exists in the file name.
IF DEFINED SiteID IF DEFINED SiteAcronm IF NOT EXIST "%DIAGNOSTICSDIR%\%SiteID%" MKDIR "%DIAGNOSTICSDIR%\%SiteID%"
IF DEFINED SiteID IF DEFINED SiteAcronm FOR /F "tokens=*" %%A IN ('DIR /b *#%SiteAcronm%#*_XML.7z 2^>nul') DO MOVE /Y "%%A" "%DIAGNOSTICSDIR%\%SiteID%"
:: Update Folder Paths parameters with _ into \ for dicrectory structures.
IF DEFINED DIR1 SET DIR1=%DIR1:_=\%
IF DEFINED DIR2 SET DIR2=%DIR2:_=\%
IF DEFINED DIR3 SET DIR3=%DIR3:_=\%
IF DEFINED DIR1 IF NOT EXIST "..\%DIR1%" MKDIR "..\%DIR1%"
IF DEFINED DIR2 IF NOT EXIST "..\%DIR2%" MKDIR "..\%DIR2%"
IF DEFINED DIR3 IF NOT EXIST "..\%DIR3%" MKDIR "..\%DIR3%"
:: Using Hirarchy logic to copy and move site files based on Defined Parameters. (i.e. DIR3 can only be defined if DIR2 and DIR1 is defined.)
IF DEFINED SiteAcronm (
    REM If ARCHIVE is "A" then it will be moved to archive after any required copies.
    IF "A"=="%ARCHIVE%" (
        REM Get a list of matchingfiles
        FOR /F "tokens=*" %%A IN ('DIR /b *#%SiteAcronm%#*.* 2^>nul') DO (
            IF DEFINED DIR1 (
                IF DEFINED DIR2 (
                    IF DEFINED DIR3 (
                        REM COPY FILE TO DIR3
                        COPY /Y "%%A" "..\%DIR3%"
                    )
                REM COPY FILE TO DIR2
                COPY /Y "%%A" "..\%DIR2%"
                )
            REM COPY FILE TO DIR1
            COPY /Y "%%A" "..\%DIR1%
            )
        REM MOVE FILE TO ARCHIVE
        MOVE /Y "%%A" "%ArchiveDIR%"
        )
    ) ELSE (
        REM Since files not to be Archived and if DIR1 isn't defined, no point scanning DIR for matching files, as nothing to be done.
        IF DEFINED DIR1 (
            REM Get a list of matchingfiles
            FOR /F "tokens=*" %%A IN ('DIR /b *#%SiteAcronm%#*.* 2^>nul') DO (
                IF DEFINED DIR2 (
                    IF DEFINED DIR3 (
                      REM COPY FILE TO DIR3
                      COPY /Y "%%A" "..\%DIR3%"
                    )
                    REM COPY FILE TO DIR2
                    COPY /Y "%%A" "..\%DIR2%"
                )
                REM MOVE FILE TO DIR1
                MOVE /Y "%%A" "..\%DIR1%"
            )
        )
    )
)
goto :eof