:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::                 FTP Sort Batch Script                     ::
::                         V2.1                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2020/04/06                           ::
::                                                           ::
::                Makes use of FTPSort.BAT                   ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
@echo off
setlocal
:: Enter Configuration Parameters below;
::===============================================================
:: ~30 second sleep Loop to reduce hard drive hammering if more frequent. (empty to disable Loop, i.e. run once and exit)
:: This depends on the data frequency and configuration of Scheduled Task.
SET LoopSleepSeconds=10

:: Number of Days to Keep Log Files
SET LogFileDays=28


::===============================================================
:: SETUP Parameters needed
IF NOT EXIST %~dp0log\. MKDIR %~dp0log
SET LOGFILE=%~dp0log\FTPSort.%DATE:/=-%.log
ECHO %TIME% Started FTP Sort with a Loop of %LoopSleepSeconds% Seconds | "%~dp0TEE" -a "%LOGFILE%"
:Main_Loop
ECHO %TIME% Main Loop
:: The Log file to be used by all scripts. (all in one place.)
SET LOGFILE=%~dp0log\FTPSort.%DATE:/=-%.log

CALL "%~dp0\FTPSort_AutoFTPut.bat"


:: Tidy up Old Log Files based on how many files we want to keep.
for /f "tokens=* skip=%LogFileDays%" %%A IN ('dir /B /O-D "%~dp0log\FTPSort.*.log"') DO DEL "%~dp0\log\%%A"


:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Repeat loop from here.
IF DEFINED LoopSleepSeconds ECHO %TIME% Waiting %LoopSleepSeconds% Seconds... & (IF EXIST %~dp0choice.exe (%~dp0Choice.exe /N /T:Y,%LoopSleepSeconds%) else (choice /N /D Y /T %LoopSleepSeconds%)) & GOTO Main_Loop
endlocal
