:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::                 FTP Sort Batch Script                     ::
::                         V4.4                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2021/08/27                           ::
::                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@ECHO OFF
:: ==================================================== Define Parameters ==================================================================
ECHO %TIME% Starting sorting files process...
:: ROOT Folder of FTP for incoming Files to be sorted. (Everything can be relative to this folder.)
SET FTPINCOMINGDIR=F:\FTP\AutoFTPut\OUTBOUND
:: Folder containing the FTP file sorting rules by filename: <Diagnostics Site ID>#<Site Acronym>#<Archive Y/N>#<Directory1>#<Directory2>#<Directory3># <Ignored, can be used as comments>
SET SORTRULESDIR=..\Sort_Rules
:: Temp Folder for sorting files so they can not be modified and are not locked.
SET FTPSORTDIR=..\TIQSORT
:: Fix Destination Folders
SET DIAGNOSTICSDIR=..\Diagnostics
SET ArchiveDIR=..\ZArchive
:: ROOT Folder for Output of files that are sorted
SET OUTGOINGDIRROOT=..
:: =========================================================================================================================================
IF NOT DEFINED LOGFILE SET LOGFILE=%~dp0log\FTPSort.%DATE:/=-%.log
ECHO %TIME% Changing to FTP Download Directory.
CD /D "%FTPINCOMINGDIR%" ||goto :eof
:: Create Default Directories (Otherwise steps may fail.)
IF NOT EXIST "%SORTRULESDIR%" MKDIR "%SORTRULESDIR%"
IF NOT EXIST "%FTPSORTDIR%" MKDIR "%FTPSORTDIR%"
IF NOT EXIST "%DIAGNOSTICSDIR%" MKDIR "%DIAGNOSTICSDIR%"
IF NOT EXIST "%ArchiveDIR%" MKDIR "%ArchiveDIR%"
:: Avoid file Locks or additional files added during processing by using a Sort Directory.
ECHO %TIME% MOVE RAR Files into Temp Sort Directory | "%~dp0TEE" -a "%LOGFILE%"
:: Test if file is locked by updating the timestamp, If test ok, MOVE to Destination
for /f "tokens=*" %%A IN ('DIR /b *.RAR 2^>nul') DO 2>nul (call;>>"%%A") && (MOVE /Y "%%A" %FTPSORTDIR% &&ECHO %TIME% Moved RAR  to %FTPSORTDIR%\%%A | "%~dp0TEE" -a "%LOGFILE%")
ECHO %TIME% MOVE 7z  Files into Temp Sort Directory | "%~dp0TEE" -a "%LOGFILE%"
:: Test if file is locked by updating the timestamp, If test ok, MOVE to Destination
:: for /f "tokens=*" %%A IN ('DIR /b *.7z 2^>nul') DO 2>nul (call;>>"%%A") && MOVE /Y "%%A" %FTPSORTDIR%
for /f "tokens=*" %%A IN ('findstr /B /M /C:7z /S *.7z') DO 2>nul (call;>>"%%A") && MOVE /Y "%%A" %FTPSORTDIR% &&ECHO %TIME% Moved 7z   to %FTPSORTDIR%\%%A | "%~dp0TEE" -a "%LOGFILE%"
ECHO %TIME% MOVE 7z [zip] Files into Temp Sort Directory | "%~dp0TEE" -a "%LOGFILE%"
for /f "tokens=*" %%A IN ('findstr /B /M /C:PK /S *.7z') DO 2>nul (call;>>"%%A") && MOVE /Y "%%A" %FTPSORTDIR% &&ECHO %TIME% Moved ZIP  to %FTPSORTDIR%\%%A | "%~dp0TEE" -a "%LOGFILE%"
REM ECHO %TIME% Check for Uploaded Files *.tmp that are complete but didn't get renamed.
REM CALL %~dp0Recover
ECHO %TIME% Changing to Temp Sort Directory
cd "%FTPSORTDIR%"
ECHO %TIME% Running All Sorting Rules as defined in Download Directory: %SORTRULESDIR%
:: Scan all sorting rules from Directory and call sorting routine.
for /f "tokens=1,2,3,4,5,6,* delims=#" %%A in ('dir /b /a-d %SORTRULESDIR%') DO (
    SET SiteID=%%A
    SET SiteAcronm=%%B
    SET ARCHIVE=%%C
    SET DIR1=%%D
    SET DIR2=%%E
    SET DIR3=%%F
    CALL :SORTFILES
    SET SiteID=
    SET SiteAcronm=
    SET ARCHIVE=
    SET DIR1=
    SET DIR2=
    SET DIR3=
)
goto :eof

:SORTFILES
ECHO %TIME% Sorting %SiteAcronm% into %SiteID%
:: MOVE DIAGNOSTICS files if required parameters are DEFINED and _XML.* exists in the file name.
IF DEFINED SiteID IF DEFINED SiteAcronm IF NOT EXIST "%DIAGNOSTICSDIR%\%SiteID%" MKDIR "%DIAGNOSTICSDIR%\%SiteID%"
IF DEFINED SiteID IF DEFINED SiteAcronm FOR /F "tokens=*" %%A IN ('DIR /b *#%SiteAcronm%#*_XML.7z 2^>nul') DO MOVE /Y "%%A" "%DIAGNOSTICSDIR%\%SiteID%"
:: Update Folder Paths parameters with _ into \ for dicrectory structures.
IF DEFINED DIR1 SET DIR1=%DIR1:_=\%
IF DEFINED DIR2 SET DIR2=%DIR2:_=\%
IF DEFINED DIR3 SET DIR3=%DIR3:_=\%
IF DEFINED DIR1 IF NOT EXIST "%OUTGOINGDIRROOT%\%DIR1%" MKDIR "%OUTGOINGDIRROOT%\%DIR1%"
IF DEFINED DIR2 IF NOT EXIST "%OUTGOINGDIRROOT%\%DIR2%" MKDIR "%OUTGOINGDIRROOT%\%DIR2%"
IF DEFINED DIR3 IF NOT EXIST "%OUTGOINGDIRROOT%\%DIR3%" MKDIR "%OUTGOINGDIRROOT%\%DIR3%"
:: Using IF DEFINED logic to Hard Link site files based on Defined Parameters.
IF DEFINED SiteAcronm (
    REM If ARCHIVE is "A" then it will be moved to archive after any required copies.
    FOR /F "tokens=*" %%A IN ('DIR /b *#%SiteAcronm%#*.* 2^>nul') DO (
    IF "A"=="%ARCHIVE%" MKLINK /H "%ArchiveDIR%\%%A" "%%A"&&ECHO %TIME% LNK 2 DIRA to %ArchiveDIR%\%%A | "%~dp0TEE" -a "%LOGFILE%"
    IF DEFINED DIR1 MKLINK /H "%OUTGOINGDIRROOT%\%DIR1%\%%A" "%%A" &&ECHO %TIME% LNK 2 DIR1 to %OUTGOINGDIRROOT%\%DIR1%\%%A | "%~dp0TEE" -a "%LOGFILE%"
    IF DEFINED DIR2 MKLINK /H "%OUTGOINGDIRROOT%\%DIR2%\%%A" "%%A" &&ECHO %TIME% LNK 2 DIR2 to %OUTGOINGDIRROOT%\%DIR2%\%%A | "%~dp0TEE" -a "%LOGFILE%"
    IF DEFINED DIR3 MKLINK /H "%OUTGOINGDIRROOT%\%DIR3%\%%A" "%%A" &&ECHO %TIME% LNK 2 DIR3 to %OUTGOINGDIRROOT%\%DIR3%\%%A | "%~dp0TEE" -a "%LOGFILE%"
    DEL /Q "%%A" &&ECHO %TIME% Del Sorted   %%A | "%~dp0TEE" -a "%LOGFILE%"
    )
)
goto :eof