:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::            Create Scheduled Task Batch Script             ::
::                         V3.1                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2017/02/06                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@ECHO OFF
setlocal
CD /D "%~dp0"
:: Version of Windows Detection
for /f "tokens=2 delims=][" %%A in ('ver^|find "Windows"') DO for /f "tokens=2,3,4 delims=. " %%I in ("%%A") DO IF "%%I"=="5" (SET winVER=XP) ELSE (IF "%%I"=="6" SET winVER=7)
:: Parent Folder Name Detection
SET RunBatch=%~nx0
SET RUNPATH=%~f0
SET RUNPATH=%RUNPATH: =#%
CALL :SHIFTVARS %RUNPATH:\= %
SET ParentFolder=%ParentFolder:#= %
:: Creates Scheduled Task to Run Every 5 Mins
IF %winVER%.==7. schtasks /create /sc MINUTE /mo 5 /tn "TrackIQ\%ParentFolder%-Sort" /tr "'%CD%\FTPSort_AutoFTPut_Loop.bat'" /ru system
IF %winVER%.==XP. schtasks /create /sc MINUTE /mo 5 /tn "%ParentFolder%-Sort" /tr "\"%CD%\FTPSort_AutoFTPut_Loop.bat\"" /ru system

IF %winVER%.==7. schtasks /create /sc MINUTE /mo 5 /tn "TrackIQ\%ParentFolder%-DMZ" /tr "'%CD%\FTPSort_DMZ_Loop.bat'" /ru system
IF %winVER%.==XP. schtasks /create /sc MINUTE /mo 5 /tn "%ParentFolder%-DMZ" /tr "\"%CD%\FTPSort_DMZ_Loop.bat\"" /ru system
pause
endlocal
GOTO :EOF

:: Tests path variables to detect only parent folder.
:SHIFTVARS
SET ParentFolder=%1
SET RunBatchTest=%2
IF "%RunBatchTest%"=="%RunBatch%" GOTO :EOF
SHIFT
GOTO :SHIFTVARS
