:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::                Disk Purge Batch Script                    ::
::                         V3.4                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2024/10/25                           ::
::                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@echo off
:: Periodically examines the directory "DIR_TO_MONITOR" by "CLEANUP_PERIOD_IN_MINUTES"
:: when the free space drops below "DISK_SPACE_IN_MEGS", the oldest directory will be wiped
:: when used on the server same applies but the oldest train folder for each site is deleted per check.

:: Detect if DiskPurge is named DiskPurge.D (drive letter) to define the Drive
CALL :FolderNameDriveLetterDetect

:: CONFIGURATION AREA (IF NOT DEFINED allows parameters to be passed in, otherwise use these defaults).

IF NOT DEFINED DRV_TO_MONITOR set DRV_TO_MONITOR=D
IF NOT DEFINED DIR_TO_MONITOR set DIR_TO_MONITOR=\server
IF NOT DEFINED DISK_SPACE_IN_MEGS set DISK_SPACE_IN_MEGS=4096
IF NOT DEFINED CLEANUP_PERIOD_IN_MINUTES set CLEANUP_PERIOD_IN_MINUTES=3

IF NOT DEFINED DPOutputLogFiles SET DPOutputLogFiles=28
IF NOT DEFINED DPurgeListMax SET DPurgeListMax=300

:: If AUXCLEAN=Do specified here, Auxiliary clean up will occur first run regardless of DISK_SPACE_IN_MEGS
:: IF NOT DEFINED AUXCLEAN set AUXCLEAN=Do

IF NOT DEFINED SERVER_MONTHS_TO_KEEP set SERVER_MONTHS_TO_KEEP=5

:: IF WPU_RAW_DATA_DAYS_TO_KEEP is defined (not blank), The WPU Will Clean up all RAW data files (as previously defined by system type) for the Period Beyond WPU_RAW_DATA_DAYS_TO_KEEP, (checked once per day, it is a time consuming process to check)
:: IF NOT DEFINED WPU_RAW_DATA_DAYS_TO_KEEP set WPU_RAW_DATA_DAYS_TO_KEEP=21

:: IF WPU_RAW_TAGED_DATA_DAYS_TO_KEEP is defined (not blank), The WPU Will Clean up RAW data files of Trains without Tags for the Period Beyond WPU_RAW_TAGED_DATA_DAYS_TO_KEEP, (checked once per day, it is a time consuming process to check)
:: IF NOT DEFINED WPU_RAW_TAGED_DATA_DAYS_TO_KEEP set WPU_RAW_TAGED_DATA_DAYS_TO_KEEP=7


:: END CONFIGURATION AREA
SETLOCAL ENABLEDELAYEDEXPANSION ENABLEEXTENSIONS
IF NOT EXIST "%~dp0PurgeList\." mkdir "%~dp0PurgeList"

SET LOGFILE=%~dp0Logs\%~n0%~1.!DATE:/=-!.log

:: Display what is going to be done
CALL :TEE "DIR_TO_MONITOR            = %DRV_TO_MONITOR%:%DIR_TO_MONITOR%"
CALL :TEE "DISK_SPACE_IN_MEGS        = %DISK_SPACE_IN_MEGS%"
CALL :TEE "CLEANUP_PERIOD_IN_MINUTES = %CLEANUP_PERIOD_IN_MINUTES%"
CALL :TEE ""
CALL :TEE "DiskPurge was started on %date% at %time% to Monitor %DRV_TO_MONITOR%:%DIR_TO_MONITOR% every %CLEANUP_PERIOD_IN_MINUTES% minutes for %DISK_SPACE_IN_MEGS%MB Free"

:: Invalid Parameter Checks
IF %SERVER_MONTHS_TO_KEEP%0 LEQ 0 CALL :TEE "Parameter SERVER_MONTHS_TO_KEEP Must be Greater than 0"& exit /b 11
IF %DISK_SPACE_IN_MEGS%0 LEQ 0 CALL :TEE "Parameter DISK_SPACE_IN_MEGS Must be Greater than 0"& exit /b 12
IF %CLEANUP_PERIOD_IN_MINUTES%0 LEQ 0 CALL :TEE "Parameter CLEANUP_PERIOD_IN_MINUTES Must be Greater than 0"& exit /b 13
IF "%DIR_TO_MONITOR:~-1,1%"=="\" SET DIR_TO_MONITOR=%DIR_TO_MONITOR:~,-1%

:: Find out how much disk space is free, compare it to threshold "DISK_SPACE_IN_MEGS"
:main_loop
REM Define Log File to use within this loop.
SET LOGFILE=%~dp0Logs\%~n0%~1.!DATE:/=-!.log

call :measure_disk_space
IF NOT %TSTVAL%.==0. (if %MEGS_FREE% LSS %DISK_SPACE_IN_MEGS% (call :cleanup_disk) ELSE (call :status_message) ) ELSE (call :error_message)
:: Tidy up Old Log Files based on how many files we want to keep.
for /f "tokens=* skip=%DPOutputLogFiles%" %%A IN ('dir /B /O-D "%~dp0\logs\%~n0*.log"') DO DEL "%~dp0\logs\%%A"
:: Tidy up Purge List Files based on how many files we want to keep.
for /f "tokens=* skip=%DPurgeListMax%" %%A IN ('dir /B /O-D "%~dp0PurgeList\*.*"') DO DEL "%~dp0PurgeList\%%A"
goto main_loop

:status_message
:: Enough space left, have a CLEANUP_PERIOD_IN_MINUTES mins sleep
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR% has %MEGS_FREE% MB free, which is enough for a threshold of %DISK_SPACE_IN_MEGS% MB"
IF "%AUXCLEAN%"=="Do" CALL :cleanup_auxiliary
IF NOT "%WPU_RAW_DATA_DAYS_TO_KEEP%"=="" CALL :cleanup_OLD_RAW_DATA
IF NOT "%WPU_RAW_TAGED_DATA_DAYS_TO_KEEP%"=="" CALL :cleanup_OLD_RAW_UNTAGGED_DATA
call :sleeping_loop
exit /b

:RUNDELAY
SET RUNDELAYseconds=%1
IF NOT DEFINED RUNDELAYseconds exit /b
IF %RUNDELAYseconds%==0  exit /b
IF EXIST %windir%\system32\choice.exe (choice /N /C YN /D Y /T %RUNDELAYseconds%) else (ping -n %RUNDELAYseconds% localhost &ping -n 2 localhost)
exit /b

:sleeping_loop
SET /A DELAYPERIODTIMEOUT=%CLEANUP_PERIOD_IN_MINUTES% * 60
CALL :RUNDELAY %DELAYPERIODTIMEOUT%
exit /b

:error_message
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR% is not responding, checking again in %CLEANUP_PERIOD_IN_MINUTES% minutes"
call :sleeping_loop
exit /b

:: cleans up the "DIR_TO_MONITOR" directory
:cleanup_disk
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR% has %MEGS_FREE% MB free, which is less than %DISK_SPACE_IN_MEGS% MB"
IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\." (CALL :cleanup_disk_WPU) ELSE (CALL :cleanup_disk_Server)
exit /b

:cleanup_disk_WPU
SET AUXCLEAN=Do
:: locate and delete oldest train folder
for /f "tokens=*" %%A IN ('dir /b /ad-a /o-n "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains"') DO SET YYYY=%%A
for /f "tokens=*" %%A IN ('dir /b /ad-a /o-n "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%" 2^>nul') DO SET MMDD=%%A
for /f "tokens=*" %%A IN ('dir /b /ad-a /o-n "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%" 2^>nul') DO SET HHMMSS=%%A
IF ""=="%YYYY%" (
    CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains Failed to locate DIR without Archive attribute SET, checking again in %CLEANUP_PERIOD_IN_MINUTES% minutes"
    call :sleeping_loop
    for /f %%A in ('dir /b /s /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains" ') DO Attrib -A "%%A" &CALL :TEE "attrib -A %%A"
    CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains all attribute bit removed as attempt to recover Disk Purge."
    exit /b
)
DEL /Q "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%\%HHMMSS%\*.*" &&CALL :TEE "Removed all files in %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%\%HHMMSS%\" ||CALL :TEE "Problem removing all files in %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%\%HHMMSS%\"
RMDIR /Q "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%\%HHMMSS%" ||CALL :TEE "Problem removing Directory %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%\%HHMMSS%"
:: IF RMDIR could not remove the directory, then assume it's got a lock, change the attribute bit to avoid it for next round
IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%\%HHMMSS%\." (
    CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%\%HHMMSS% Is locked, setting Archive attribute"
    Attrib "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%\%HHMMSS%" +a
    for /f %%A in ('dir /ad-a "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%" ^|findstr "Dir(s)"') DO IF "%%A"=="2" (
        CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD% Is locked, setting Archive attribute"
        attrib "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%" +a
    )
    for /f %%A in ('dir /ad-a "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%" ^|findstr "Dir(s)"') DO IF "%%A"=="2" (
        CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY% Is locked, setting Archive attribute"
        attrib "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%" +a
    )
) ELSE (
    CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%YYYY%\%MMDD%\%HHMMSS% Removed"
)
IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\TrainList\%YYYY%_%MMDD%_%HHMMSS%" MOVE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\TrainList\%YYYY%_%MMDD%_%HHMMSS%" "%~dp0PurgeList"
SET YYYY=&SET MMDD=&SET HHMMSS=
exit /b

:cleanup_disk_Server
SET AUXCLEAN=Done
for /f "tokens=*" %%B IN ('dir /b /on "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%"') DO IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%B\trains\." (
  SET Server_Purge=cleanup_disk_Server_Purge_Day
) ELSE (
  for /f "tokens=*" %%E IN ('dir /b /on /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%B"') DO IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%B\%%E\trains\."(
    SET Server_Purge=cleanup_disk_Server_Purge_Day_FleetOne
  ) ELSE (
    SET Server_Purge=cleanup_disk_Server_Purge_Day_FleetOne_FULL
  )
)
CALL :TEE ":%Server_Purge%"
CALL :%Server_Purge%
call :sleeping_loop
exit /b

:: BUILD An array of full path "Day" directories from Newest to oldest, then SKIP X days to start deleting
:cleanup_disk_Server_Purge_Day
CALL :TEE "cleanup_disk_Server_Purge_Day"
SET DIR_TO_SCAN=%DRV_TO_MONITOR%:%DIR_TO_MONITOR%
for /f "tokens=*" %%B IN ('dir /b /on "%DIR_TO_SCAN%"') DO (

)
exit /b


:cleanup_disk_Server_Purge_Day_FleetOne
CALL :TEE "cleanup_disk_Server_Purge_Day_FleetOne"
exit /b

:cleanup_disk_Server_Purge_Day_FleetOne_FULL
CALL :TEE "cleanup_disk_Server_Purge_Day_FleetOne_FULL"
exit /b

:OLD_CODE
pause

:: locate the Most Current train Folder for each Site and calculate the Last Train Folder Month to Keep for Each System
:: (i.e. "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\<SITE ID>\trains\YYYY\MM" - SERVER_MONTHS_TO_KEEP = DiskPurgeLM#)
for /f "tokens=*" %%B IN ('dir /b /on "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%"') DO (
  IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%B\trains\." (
    SET Server_Purge=cleanup_disk_Server_Purge_Month
      for /f "tokens=*" %%A IN ('dir /b /on /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%B\trains"') DO SET YYYY=%%A
      for /f "tokens=*" %%A IN ('dir /b /on /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%B\trains\!YYYY!" 2^>nul') DO SET MMDD=%%A
      for /f "tokens=*" %%A IN ('dir /b /on /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%B\trains\!YYYY!\!MMDD!" 2^>nul') DO SET HHMMSS=%%A
      REM SET DiskPurgeCM#%%B=!YYYY!!MMDD!
      SET MM=!MMDD:~0,-2!
      SET /A MM=1!MM!-100-%SERVER_MONTHS_TO_KEEP%
      IF !MM! LEQ 0 (
          SET /A YYYY=!YYYY!-%SERVER_MONTHS_TO_KEEP%/12
          SET /A MM=%SERVER_MONTHS_TO_KEEP%/12 * 12 + !MM!
          IF !MM! LEQ 0 (
              SET /A YYYY=!YYYY!-1
              SET /A MM=12 + !MM!
              SET DiskPurgeLM#%%B=!YYYY!#!MM!#trains#-LONG
          ) ELSE (
              SET DiskPurgeLM#%%B=!YYYY!#!MM!#trains#-LESS
          )
      ) ELSE (
          SET DiskPurgeLM#%%B=!YYYY!#!MM!#trains#-MORE
      )
  ) ELSE (
    SET Server_Purge=cleanup_disk_Server_Purge_Month_FleetOne
    for /f "tokens=*" %%E IN ('dir /b /on /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%B"') DO (
        for /f "tokens=*" %%A IN ('dir /b /on /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%B\%%E\trains"') DO (
          SET YYYY=%%A
          for /f "tokens=*" %%A IN ('dir /b /on /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%B\%%E\trains\!YYYY!" 2^>nul') DO SET MMDD=%%A
          REM SET DiskPurgeCM#%%B=!YYYY!!MMDD!
          SET MM=!MMDD:~0,-2!
          SET /A MM=1!MM!-100-%SERVER_MONTHS_TO_KEEP%
          IF !MM! LEQ 0 (
              SET /A YYYY=!YYYY!-%SERVER_MONTHS_TO_KEEP%/12
              SET /A MM=%SERVER_MONTHS_TO_KEEP%/12 * 12 + !MM!
              IF !MM! LEQ 0 (
                  SET /A YYYY=!YYYY!-1
                  SET /A MM=12 + !MM!
                  SET DiskPurgeLM#%%B=!YYYY!#!MM!#%%E#-LONG
              ) ELSE (
                  SET DiskPurgeLM#%%B=!YYYY!#!MM!#%%E#-LESS
              )
          ) ELSE (
              SET DiskPurgeLM#%%B=!YYYY!#!MM!#%%E#-MORE
          )
        )
     )

  )
)
CALL :%Server_Purge%
CALL :TEE ":%Server_Purge%"
call :sleeping_loop
exit /b

:cleanup_disk_Server_Purge_Month
CALL :TEE "Purge Month %DiskPurgeLM%"
:: locate the Oldest train folder for each site and if it older than the Last Train Folder Month Remove it.
for /f "tokens=2,3,4* delims=#=" %%A IN ('set DiskPurgeLM#') DO (
    for /f "tokens=*" %%E IN ('dir /b /ad /o-n "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%A\trains\." 2^>nul') DO SET YYYY=%%E
    IF !YYYY! EQU %%B (
        for /f "tokens=*" %%F IN ('dir /b /ad /o-n "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%A\trains\!YYYY!\." 2^>nul') DO SET MMDD=%%F
        SET /A MM=1!MMDD:~0,-2! - 100
        IF !MM!==%%C (
            CALL :TEE "!YYYY!\!MM! "Folder" Vs %%B\%%C "Keep" Same @%%A"
        ) ELSE (
            SET /A TEST= %%C - !MM!
            IF !TEST! LEQ 0 (
                CALL :TEE "!YYYY!\!MM! "Folder" Vs %%B\%%C "Keep" Newer @%%A"
            ) ELSE (
                CALL :TEE "!YYYY!\!MM! "Folder" Vs %%B\%%C "Keep" Month Remove @%%A"
                FOR /l %%H IN (1,1,9) DO (
                    IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%A\trains\!YYYY!\!MMDD:~0,-2!0%%H\." (
                        RMDIR /Q /S "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%A\trains\!YYYY!\!MMDD:~0,-2!0%%H"
                        CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%A\trains\!YYYY!\!MMDD:~0,-2!0%%H Removed {!ERRORLEVEL!}"
                    )
                )
                FOR /l %%H IN (10,1,31) DO (
                    IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%A\trains\!YYYY!\!MMDD:~0,-2!%%H\." (
                        RMDIR /Q /S "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%A\trains\!YYYY!\!MMDD:~0,-2!%%H"
                        CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%A\trains\!YYYY!\!MMDD:~0,-2!%%H Removed {!ERRORLEVEL!}"
                    )
                )
            )
        )
    ) ELSE (
        SET /A TEST=%%B-!YYYY!
        IF !TEST! LEQ 0 (
            CALL :TEE "!YYYY!\  "Folder" Vs %%B\%%C "Keep" Newer @%%A"
        ) ELSE (
            CALL :TEE "!YYYY!\  "Folder" Vs %%B\%%C "Keep" Year Remove @%%A"
            IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%A\trains\!YYYY!\." (
                RMDIR /Q /S "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%A\trains\!YYYY!"
                CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%A\trains\!YYYY! Removed {!ERRORLEVEL!}"
            )
        )
    )
    SET DiskPurgeLM#%%A=
)
SET YYYY=
SET MMDD=
SET MM=
exit /b


:cleanup_disk_Server_Purge_Month_FleetOne
CALL :TEE "Purge Month %DiskPurgeLM%"
:: locate the Oldest train folder for each site and if it older than the Last Train Folder Month Remove it.
for /f "tokens=2,3,4* delims=#=" %%A IN ('set DiskPurgeLM#') DO (
    for /f "tokens=*" %%E IN ('dir /b /ad /o-n "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%D\%%A\trains\." 2^>nul') DO SET YYYY=%%E
    IF !YYYY! EQU %%B (
        for /f "tokens=*" %%F IN ('dir /b /ad /o-n "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%D\%%A\trains\!YYYY!\." 2^>nul') DO SET MMDD=%%F
        SET /A MM=1!MMDD:~0,-2! - 100
        IF !MM!==%%C (
            CALL :TEE "!YYYY!\!MM! "Folder" Vs %%B\%%C "Keep" Same @%%A-%%D"
        ) ELSE (
            SET /A TEST= %%C - !MM!
            IF !TEST! LEQ 0 (
                CALL :TEE "!YYYY!\!MM! "Folder" Vs %%B\%%C "Keep" Newer @%%A-%%D"
            ) ELSE (
                CALL :TEE "!YYYY!\!MM! "Folder" Vs %%B\%%C "Keep" Month Remove @%%A-%%D"
                FOR /l %%H IN (1,1,9) DO (
                    IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%D\%%A\trains\!YYYY!\!MMDD:~0,-2!0%%H\." (
                        RMDIR /Q /S "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%D\%%A\trains\!YYYY!\!MMDD:~0,-2!0%%H"
                        CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%D\%%A\trains\!YYYY!\!MMDD:~0,-2!0%%H Removed {!ERRORLEVEL!}"
                    )
                )
                FOR /l %%H IN (10,1,31) DO (
                    IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%D\%%A\trains\!YYYY!\!MMDD:~0,-2!%%H\." (
                        RMDIR /Q /S "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%D\%%A\trains\!YYYY!\!MMDD:~0,-2!%%H"
                        CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%D\%%A\trains\!YYYY!\!MMDD:~0,-2!%%H Removed {!ERRORLEVEL!}"
                    )
                )
            )
        )
    ) ELSE (
        SET /A TEST=%%B-!YYYY!
        IF !TEST! LEQ 0 (
            CALL :TEE "!YYYY!\  "Folder" Vs %%B\%%C "Keep" Newer @%%A-%%D"
        ) ELSE (
            CALL :TEE "!YYYY!\  "Folder" Vs %%B\%%C "Keep" Year Remove @%%A-%%D"
            IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%D\%%A\trains\!YYYY!\." (
                RMDIR /Q /S "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%D\%%A\trains\!YYYY!"
                CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\%%D\%%A\trains\!YYYY! Removed {!ERRORLEVEL!}"
            )
        )
    )
    SET DiskPurgeLM#%%A=
)
SET YYYY=
SET MMDD=
SET MM=
exit /b

:: Cleans up auxiliary generated files that could be time consuming.
:cleanup_auxiliary
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\TrainList Clean up started"
:: Check if trainlist has been implemented and cleans up the list
IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\TrainList\." (for /F " tokens=* " %%a in ('DIR /B /a-d "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\TrainList\"') DO (
      SET FILE=%%a
      IF NOT EXIST "D:\Server\Trains\!FILE:_=\!\."  DEL D:\Server\TrainList\!FILE! &&CALL :TEE "Removed D:\Server\TrainList\!FILE!" || CALL :TEE "NOT Removed D:\Server\TrainList\!FILE!"
))
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\pointers Clean up started"
:: check pointers for matching train folders (Similar to above but need to check within the files.) Delete invalid pointers.
IF EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\pointers" for /f %%A IN ('dir /s /b "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\pointers\*.htm" 2^>nul') DO for /f "tokens=4,5,6,* delims=/" %%D IN ('findstr "^<META" "%%A"') DO IF NOT EXIST %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%%D\%%E\%%F\. CALL :Remove_File %%A
IF NOT EXIST "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\." (
    CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR% Clean up of all play.png, show.png, PBS*.htm files."
    :: Clean up from all folders regardless of date
    DEL /s /q %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\play.png &&CALL :TEE "Removed %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\play.png" ||CALL :TEE "Not Removed %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\play.png"
    DEL /s /q %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\show.png &&CALL :TEE "Removed %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\show.png" ||CALL :TEE "Not Removed %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\show.png"
    DEL /s /q %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\PBS*.htm &&CALL :TEE "Removed %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\PBS*.htm" ||CALL :TEE "Not Removed %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\PBS*.htm"
)
SET AUXCLEAN=Done
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR% purge has completed, now with over %DISK_SPACE_IN_MEGS% MB Free"
exit /b

:: Clean up old RAW Data as defined by WPU_RAW_DATA_DAYS_TO_KEEP Once a Day Check for Clean up old RAW Data
:cleanup_OLD_RAW_DATA
IF "%DATE%"=="%WPU_RAW_DATA_CLEAN_DAILY%" exit /b
SET WPU_RAW_DATA_CLEAN_DAILY=%DATE%
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR% Clean up of RAW Data older than %WPU_RAW_DATA_DAYS_TO_KEEP% days has started"
SET WPU_RAW_DATA_DAYS_TO_KEEP_TEST=0
:: locate the Most Current train Folder and calculate
:: (i.e. "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\YYYY\MMDD" - WPU_RAW_DATA_DAYS_TO_KEEP = DiskPurgeLM#)
for /f "tokens=*" %%A IN ('dir /b /o-n /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains"') DO for /f "tokens=*" %%B IN ('dir /b /o-n /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%%A" 2^>nul') DO (
  SET /A WPU_RAW_DATA_DAYS_TO_KEEP_TEST=!WPU_RAW_DATA_DAYS_TO_KEEP_TEST! + 1
  IF !WPU_RAW_DATA_DAYS_TO_KEEP_TEST! GTR %WPU_RAW_DATA_DAYS_TO_KEEP% CALL :cleanup_OLD_RAW_DATA_DAY %%A\%%B
)
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR% purge completed of RAW Data older than %WPU_RAW_DATA_DAYS_TO_KEEP% days"
exit /b

:cleanup_OLD_RAW_UNTAGGED_DATA
IF "%DATE%"=="%WPU_RAW_UNTAGGED_DATA_CLEAN_DAILY%" exit /b
SET WPU_RAW_UNTAGGED_DATA_CLEAN_DAILY=%DATE%
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR% Clean up of RAW UnTagged Data older than %WPU_RAW_TAGED_DATA_DAYS_TO_KEEP% days has started"
SET WPU_RAW_TAGED_DATA_DAYS_TO_KEEP_TEST=0
:: locate the Most Current train Folder and calculate
:: (i.e. "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\YYYY\MMDD" - WPU_RAW_UNTAGGED_DATA_DAYS_TO_KEEP = DiskPurgeLM#)
for /f "tokens=*" %%A IN ('dir /b /o-n /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains"') DO for /f "tokens=*" %%B IN ('dir /b /o-n /ad "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%%A" 2^>nul') DO (
  SET /A WPU_RAW_TAGED_DATA_DAYS_TO_KEEP_TEST=!WPU_RAW_TAGED_DATA_DAYS_TO_KEEP_TEST! + 1
  IF !WPU_RAW_TAGED_DATA_DAYS_TO_KEEP_TEST! GTR %WPU_RAW_TAGED_DATA_DAYS_TO_KEEP% CALL :cleanup_OLD_RAW_UNTAGGED_DATA_DAY %%A\%%B
)
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR% purge completed of RAW UnTagged Data older than %WPU_RAW_TAGED_DATA_DAYS_TO_KEEP% days"
exit /b

:cleanup_OLD_RAW_DATA_DAY
IF NOT EXIST %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%1\. CALL :TEE "DiskPurge RAW_DATA_DAY not found" &exit /b
:: WCM and RailBAM store RAW files in "DAT" files.
for /f "tokens=*" %%B IN ('dir /b /s "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%1\*.dat"') DO CALL :Remove_File "%%B"
:: RailBAM has an option to compress the RAW "DAT" files and hence are now raw_dat.7z files.
for /f "tokens=*" %%B IN ('dir /b /s "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%1\raw_dat.7z"') DO CALL :Remove_File "%%B"
:: RailCAMTag Mobotix store unprocessed images as Mx_yyyy-mm-dd_HH-MM-SS.FFF.jpg but processed images as Mx_yyyy-mm-dd_HH-MM-SS.FFF{ Extra Info }.jpg  hence need to use fixed length to clean up.
for /f "tokens=*" %%B IN ('dir /b /s "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%1\??_????-??-??_??-??-??.???.jpg"') DO CALL :Remove_File "%%B"
:: RailCAMTag preprocessed images to be removed also.
for /f "tokens=*" %%B IN ('dir /b /s "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%1\preprocessed_*.jpg"') DO CALL :Remove_File "%%B"
:: RailCAMTag GigE store unprocessed images in an AVI video file.
for /f "tokens=*" %%B IN ('dir /b /s "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%1\*.avi"') DO CALL :Remove_File "%%B"
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%1\ Removed RAW Data"
exit /b

:cleanup_OLD_RAW_UNTAGGED_DATA_DAY
IF NOT EXIST %DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%1\. CALL :TEE "DiskPurge RAW_DATA_DAY not found" &exit /b
:: WCM and RailBAM store RAW files in "DAT" files.
for /f "tokens=*" %%B IN ('dir /b /s "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%1\analysis.log"') DO CALL :cleanup_OLD_RAW_UNTAGGED_DATA_DAY_Train "%%~dpB"
CALL :TEE "%DRV_TO_MONITOR%:%DIR_TO_MONITOR%\trains\%1\ Removed Untagged RAW Data"
exit /b

:cleanup_OLD_RAW_UNTAGGED_DATA_DAY_Train
SET REMOVE_RAW_Train_DAT=0
REM Count of No Axles found 0 = train, > = no train and possibly re-analysed.
for /f "skip=1 tokens=3 delims=:" %%C in ('find /C "No Axles found" %~dp1analysis.log') DO SET /A REMOVE_RAW_Train_DAT=%REMOVE_RAW_Train_DAT% + %%C
REM CSV entries for ,N_Cars,N_Locos,N_CarsTagged,N_LocosTagged If Last Two are Empty = no tags, then add first two to make a number higher than 0.
for /f "tokens=*" %%D in ('dir /b %~dp1trntbl*.csv 2^>nul') DO for /f "skip=1 tokens=10,11,12,13,* delims=," %%E in (%~dp1%%D) DO IF "00"=="%%G%%H" SET /A REMOVE_RAW_Train_DAT=%REMOVE_RAW_Train_DAT% + %%E + %%F
REM Only remove Train DAT files if REMOVE_RAW_Train_DAT is not 0
IF NOT "0"=="%REMOVE_RAW_Train_DAT%" for /f "tokens=*" %%I IN ('dir /b "%~dp1*.dat" 2^>nul') DO CALL :Remove_File "%~dp1%%I"
IF NOT "0"=="%REMOVE_RAW_Train_DAT%" for /f "tokens=*" %%I IN ('dir /b "%~dp1tvect*.mat" 2^>nul') DO CALL :Remove_File "%~dp1%%I"
IF NOT "0"=="%REMOVE_RAW_Train_DAT%" for /f "tokens=*" %%I IN ('dir /b "%~dp1ana_paras*.mat" 2^>nul') DO CALL :Remove_File "%~dp1%%I"
IF NOT "0"=="%REMOVE_RAW_Train_DAT%" for /f "tokens=*" %%I IN ('dir /b "%~dp1ana_stat*.mat" 2^>nul') DO CALL :Remove_File "%~dp1%%I"
exit /b

:Remove_File
DEL /Q "%1" &&CALL :TEE "%1 File Removed" ||CALL :TEE "%1 File Not Removed"
exit /b

:: Collects the amount of free space in Bytes and returns the Mega Bytes of free space in "MEGS_FREE" if this failes "TSTVAL" = 0
:measure_disk_space
for /f "tokens=3" %%a in ('dir %DRV_TO_MONITOR%:%DIR_TO_MONITOR% 2^>nul ^|findstr /C:"bytes free"') do for /f "tokens=1,2,3,4,5,6 delims=," %%A in ("%%a") do (SET VAL1=%%A&SET VAL2=%%B&SET VAL3=%%C&SET VAL4=%%D&SET VAL5=%%E&SET VAL6=%%F)
:: Calculate the Magnitude of the comma seperated free space.
SET TSTVAL=0
IF NOT .==.%VAL1% SET /A TSTVAL=%TSTVAL% + 1
IF NOT .==.%VAL2% SET /A TSTVAL=%TSTVAL% + 1
IF NOT .==.%VAL3% SET /A TSTVAL=%TSTVAL% + 1
IF NOT .==.%VAL4% SET /A TSTVAL=%TSTVAL% + 1
IF NOT .==.%VAL5% SET /A TSTVAL=%TSTVAL% + 1
IF NOT .==.%VAL6% SET /A TSTVAL=%TSTVAL% + 1
:: Remove Leading Zeros
:: VAL1 will never have leading zeros because it's the MSB
IF DEFINED VAL2 SET /A VAL2=1%VAL2% - 1000
IF DEFINED VAL3 SET /A VAL3=1%VAL3% - 1000
IF DEFINED VAL4 SET /A VAL4=1%VAL4% - 1000
IF DEFINED VAL5 SET /A VAL5=1%VAL5% - 1000
IF DEFINED VAL6 SET /A VAL6=1%VAL6% - 1000
:: IF drive not exist (Wrong variable or Drive has Failed.)
IF 0 == %TSTVAL% SET MEGS_FREE=0
:: Bytes is less then 1MB ANS = 0
IF 1 == %TSTVAL% SET MEGS_FREE=0
:: KBytes is less then 1MB ANS = 0
IF 2 == %TSTVAL% SET MEGS_FREE=0
:: MBytes 597/626 is equivilent to (1000^2/1024^2)
IF 3 == %TSTVAL% SET /A MEGS_FREE=(%VAL1%*1000+%VAL2%)*597/626/1000
:: GBytes 597/626 is equivilent to (1000^2/1024^2) rounding errors... (953673)
IF 4 == %TSTVAL% SET /A MEGS_FREE=((%VAL1%*1000+%VAL2%)*2*597/626*500+%VAL3%*597/626)/1000
:: TBytes 597/626 is equivilent to (1000^2/1024^2) calculated at 500th it's stored value (32bit limit) rounding errors... (953673953)
IF 5 == %TSTVAL% SET /A MEGS_FREE=(%VAL1%*1000+%VAL2%)*2*597/626*500+(%VAL3%*1000+%VAL4%)*597/626/1000
:: MAX Bytes (Greater then 999 Tbytes free space is unsuported, maximum 32bit value is 2147483647) Return 1TB
IF 6 == %TSTVAL% SET MEGS_FREE=1000000000
:: Clean up Variables
for /l %%A IN (1,1,6) DO SET VAL%%A=
exit /b

:: Tests path variables to detect only parent folder.
:SHIFTVARS
SET ParentFolder=%1
SET RunBatchTest=%2
IF "%RunBatchTest%"=="" exit /b
SHIFT
GOTO :SHIFTVARS
exit /b

:FolderNameDriveLetterDetect
:: Parent Folder Name Detection
SET RUNPATH=%~dp0
SET RUNPATH=%RUNPATH: =#%
CALL :SHIFTVARS %RUNPATH:\= %
SET ParentFolder=%ParentFolder:#= %
:: Assign "DRV_TO_MONITOR" based on this folder name (First Charator after. IF EXISTS)
for /f "tokens=2 delims=." %%A IN ("%ParentFolder%") DO IF EXIST "%%A:\." SET DRV_TO_MONITOR=%%A
IF DEFINED DRV_TO_MONITOR SET DRV_TO_MONITOR=%DRV_TO_MONITOR:~0,1%
exit /b

:TEE
IF NOT EXIST %~dp0Logs mkdir %~dp0Logs
ECHO !TIME! %~1>> "%LOGFILE%"
ECHO !TIME! %~1
exit /b
