:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::            Create Scheduled Task Batch Script             ::
::                         V3.7                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2020/04/06                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@ECHO OFF
CD /D "%~dp0"
setlocal
SET SHORTDIR=TrackIQ
:: If Exist Get possible Translations from Common File.
IF EXIST "%~dp0..\ProcessMonitorBatch\mkmessages.cmd" CALL "%~dp0..\ProcessMonitorBatch\mkmessages.cmd" SHORTCommon

:: Version of Windows Detection
for /f "tokens=2 delims=][" %%A in ('ver^|find "Windows"') DO for /f "tokens=2,3,4 delims=. " %%I in ("%%A") DO IF "%%I"=="5" (SET winVER=XP) ELSE (SET winVER=7)
:: Parent Folder Name Detection
SET RUNPATH=%~dp0
SET RUNPATH=%RUNPATH: =#%
CALL :SHIFTVARS %RUNPATH:\= %
SET ParentFolder=%ParentFolder:#= %
:: Find *.bat file to use largest as the main Scheduled Task Entry.
FOR /F "tokens=*" %%a in ('DIR /B /OS "%~dp0\*.bat"') DO SET FILE=%%a
:: Creates Scheduled Task to Run Every 5 Mins
IF %winVER%.==7. schtasks /create /sc DAILY /RI 5 /ST 00:05 /DU 24:00 /tn "%SHORTDIR%\%ParentFolder%" /tr "'%~dp0%FILE%'" /ru System
IF %winVER%.==XP. schtasks /create /sc MINUTE /mo 5 /tn "%ParentFolder%" /tr "\"%~dp0%FILE%\"" /ru System
SET winVER=


IF NOT EXIST "%~dp0log\." MKDIR "%~dp0log"
IF EXIST "%~dp0..\ProcessMonitorBatch\mkmessages.cmd" (
   CALL "%~dp0..\ProcessMonitorBatch\mkmessages.cmd" DPShortDSK
) ELSE (
   ECHO Creating Desktop Shortcuts
)


PUSHD "%ALLUSERSPROFILE%\Desktop"
:: DiskPurge Log File
   %~dp0mkshortcuts.vbs /target:"%WINDIR%\explorer.exe" /params:"%~dp0log\" /shortcut:"%ParentFolder% Log" /Icon:"%SystemRoot%\system32\SHELL32.dll,165"
POPD

IF NOT EXIST "%ALLUSERSPROFILE%\Start Menu\Programs\%SHORTDIR%\." MKDIR "%ALLUSERSPROFILE%\Start Menu\Programs\%SHORTDIR%"

IF EXIST "%~dp0..\ProcessMonitorBatch\mkmessages.cmd" (
   CALL "%~dp0..\ProcessMonitorBatch\mkmessages.cmd" DPShortSTRT
) ELSE (
   ECHO Creating TrackIQ Start Menu Folder Shortcuts
)
PUSHD "%ALLUSERSPROFILE%\Start Menu\Programs\%SHORTDIR%"
:: DiskPurge Shortcuts
   %~dp0mkshortcuts.vbs /target:"%WINDIR%\explorer.exe" /params:"%~dp0log\" /shortcut:"%ParentFolder% Log" /Icon:"%SystemRoot%\system32\SHELL32.dll,165"

IF EXIST %~dp0choice.exe (%~dp0Choice.exe /N /T:Y,10) else (choice /N /D Y /T 10)
endlocal
GOTO :EOF

:: Tests path variables to detect only parent folder.
:SHIFTVARS
SET ParentFolder=%1
SET RunBatchTest=%2
IF "%RunBatchTest%"=="" exit /b
SHIFT
GOTO :SHIFTVARS
exit /b