:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::           Systems Configuration Tool Batch Script         ::
::                                                           ::
::                  by Bernard Buterin                       ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@ECHO ON
SET VER=8.0
SET FD=2025/05/15
:: A Command to change the current directory to the directory containing the running batch file.
CD /D "%~dp0"
:: If this file was in the root folder instead, ensure current folder is _autorun (No output)
cd _autorun 2>nul
:: Defines the current Environment Parameters to be restored at endlocal
:: Change the Colour of the Console
COLOR 0A
:: Ensure CodePage is English Australian.
chcp 850
:: Set Appication Executable Directory [TIQFolder is First Sub Folder of the Path this is run in]
SET AED=%~dp0
for /f "tokens=1,2,* delims=\" %%A in ("%~dp0") DO SET TIQFolder=%%A\%%B\
SET MENU=Initialize
CALL :TITLE
CALL :ConfirmDependancies
:: Test for write access to Program Files (User Access Control Privileges)
copy %windir%\win.ini "c:\Program Files\Windows NT" 1>nul 2>nul
IF ERRORLEVEL 1 CALL :UACPrompt &EXIT /B
:: Define Menu to use
SET MENU=MainMenu
SET STEP=MainMenu
:: Version of Windows Detection
for /f "tokens=2 delims=][" %%A in ('ver^|find "Windows"') DO for /f "tokens=2,3,4 delims=. " %%I in ("%%A") DO IF "%%I"=="5" (SET winVER=XP) ELSE (IF "%%I"=="6" (SET winVER=7) ELSE (SET winVER=%%I) )
:: ECHO Code Compatability:%%I Release:%%J Serive pack:%%K
CALL :TITLE

:: Master Loop Control
:LOOP


REM Find on the path a Batchfile with %STEP% in the name
for /f "tokens=*" %%B in ('dir /b /s "%~dp0..\*%STEP%.BAT" 2^>nul') DO (
  call "%%B"
  ECHO.
  IF NOT DEFINED CHC SET CHC=YQN
  IF NOT DEFINED SLCTL SET SLCTL=%STEP% EXIT %MENU%
  IF NOT DEFINED CHOICEMSG SET CHOICEMSG=Would you like to retry the previous step %STEP% [Y/N]?
)
REM If above fails to run and define CHC, it must be a label
IF NOT DEFINED CHC call :%STEP%
REM IF CHC is not defined, Choice fails
CALL :WINTITLE
IF DEFINED CHC CHOICE /N /c %CHC% /m "  %CHOICEMSG%"
IF DEFINED CHC call :SELECTEL %SLCTL%
SET CHC=
SET SLCTL=
SET CHOICEMSG=
CALL :TITLE
IF NOT %STEP%==EXIT GOTO LOOP

:: Exit Display message
ECHO.
ECHO Exiting the %TIQFolder:~3,-1% System Configuration Tool Ver. %VER:~0,3% designed for Windows %winVER%.
ECHO.
:: Clean Up Environment Variables.
IF EXIST "c:\Program Files\Windows NT\win.ini"  DEL /Q "c:\Program Files\Windows NT\win.ini" 1>nul 2>nul
:: a time out command to show the exit message.
timeout /t 10
:: Return the colour back to original state
COLOR
:: Exit Batch file with Errorlevel 0 (i.e. no Problem)
EXIT /B 0

:MainMenu
SET MENU=MainMenu
ECHO  Wayside Site Configuration Tool Menu
SET CHC=QRHP
SET SLCTL=EXIT MainMenu HELP CMDR
CALL "%~dp0CHO" 0
IF EXIST "%~dp0..\..\..\ProcessMonitorBatch\." CALL "%~dp0CHO" ProcessMONBatch Process Monitor Batch Configuration
IF EXIST "%~dp0WPURegSet.bat" CALL "%~dp0CHO" WPURegSet WPU Registry Settings
IF EXIST "%~dp0Firewall.bat" CALL "%~dp0CHO" Firewall Configure Firewall Rules

IF EXIST "%~dp0SDI.bat" CALL "%~dp0CHO" SDI Configure Site Information
IF EXIST "%~dp0..\..\..\VQServer\." CALL "%~dp0CHO" VQServer VQ Server Configuration
IF EXIST "%~dp0Shortcuts.bat" CALL "%~dp0CHO" Shortcuts Create Desktop Shortcuts
IF EXIST "%~dp0winntp.bat" CALL "%~dp0CHO" winntp Configure Windows NTP Settings
ECHO.
IF NOT %WinVer%.==XP. IF EXIST IPADDRESS.BAT CALL "%~dp0CHO" IPADDRESS Modify WPU IP Address [Digital Systems]
IF EXIST "%~dp0TIQDS.bat" CALL "%~dp0CHO" TIQDS TrackIQ Deployed Code

ECHO.
ECHO  Attached Hardware
IF EXIST "%~dp0APCEQIP.bat"  CALL "%~dp0CHO" APCEQIP Set APC Equipment IP Address

SET CHOICEMSG=Q- Quit
EXIT /b

:SELECTEL
:: This Function uses the Error Level Number to select from the list of parameters passed to it
IF %1. == . exit /b 1
for /L %%A IN (2,1,%ERRORLEVEL%) DO SHIFT
SET STEP=%1
EXIT /B

:WINTITLE

  TITLE %TIQFolder:~3,-1%  Systems Configuration Tool Ver. %VER:~0,3% - %MENU%
exit /b

:TITLE
@ECHO OFF
CLS
ECHO  %FD:~0,10% - Ver. %VER:~0,3% - %TIQFolder:~3,-1% Systems Configuration 
ECHO.
exit /b

:UACPrompt
ECHO.
ECHO Administrative Privileges are Required to Continue...
ECHO.
ECHO Requesting User Access Control permissions, 
ECHO please agree to the User Access Control prompt
ECHO.
ECHO Avoid this next time by 
ECHO.
ECHO Right Clicking this batch file and selecting Run as Administrator
ECHO.
ECHO or
ECHO.
ECHO Turn User Access Control off in control panel and restart the computer
ECHO.
ECHO This windows will close in... 
ECHO Set UAC = CreateObject^("Shell.Application"^) > "%temp%\getadmin.vbs"
ECHO UAC.ShellExecute "cmd.exe", "/c %~f0", "", "runas", 1 >> "%temp%\getadmin.vbs"
start "UAC Run" "%temp%\getadmin.vbs"
timeout /t 5
del "%temp%\getadmin.vbs"
exit /B
:EXEDependancy
ECHO Locating Executable: %~2
:: Check if EXE is in the current folder
IF EXIST "%~dp0%~2" SET %1=%~dp0%~2 &exit /b 0
:: Check if EXE is in the Install Disk Support Folder
IF EXIST "%~dp0..\Support\%~2"   SET %1="%~dp0..\Support\%~2" &exit /b 0
:: System wide check command line with --version call (cURL and Tee compatiable)
%~2 --version >nul 2>nul
IF 0==%ERRORLEVEL% SET %1=%~2 &exit /b 0
:: Check if EXE is in Program Files Structure
IF DEFINED ProgramFiles for /f "tokens=*" %%A in ('dir /b /s "%ProgramFiles%\%~2"') do SET %1="%%A" &exit /b 0
IF DEFINED ProgramFiles(x86) for /f "tokens=*" %%A in ('dir /b /s "%ProgramFiles(x86)%\%~2"') do SET %1="%%A" &exit /b 0
exit /b 404

:ConfirmDependancies
IF NOT EXIST "%~dp0License.txt" CALL :BUILD_License "%~dp0License.txt"
IF NOT EXIST "%~dp0CMD.bat" CALL :BUILD_CMD "%~dp0CMD.bat"
IF NOT EXIST "%~dp0_START_CMDR.bat" CALL :BUILD_START_CMDR "%~dp0_START_CMDR.bat"
IF NOT EXIST "%~dp0HELP.BAT" CALL :BUILD_HELP "%~dp0HELP.BAT"
IF NOT EXIST "%~dp0mkshortcuts.vbs" (
  ECHO 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 >"%~dp0mkshortcuts.base64"
  certutil -decode "%~dp0mkshortcuts.base64" "%~dp0mkshortcuts.vbs"
  IF EXIST "%~dp0mkshortcuts.base64" del "%~dp0mkshortcuts.base64"
)
IF NOT EXIST "%~dp0CHO.BAT" (
  ECHO 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 >"%~dp0CHO.base64"
  certutil -decode "%~dp0CHO.base64" "%~dp0CHO.bat"
  IF EXIST "%~dp0CHO.base64" del "%~dp0CHO.base64"
)
exit/b


:BUILD_START_CMDR
ECHO @START "Command Prompt" "%%~dp0CMD.BAT" >%1
exit /b

:BUILD_CMD
ECHO @ECHO OFF >%1
ECHO :LOOP >>%1
ECHO SET /p RUN="%%CD%%>" >>%1
ECHO %%RUN%% >>%1
ECHO GOTO LOOP >>%1
exit /b

:BUILD_License
ECHO   The  Systems Configuration Tool License for use and distribution  >%1
ECHO   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  >>%1
ECHO. >>%1
ECHO      This Systems Configuration Tool has a compolation of programs and settings as required by >>%1
ECHO      Wabtec KinetiX Products. This list is maintained online >>%1
ECHO      Visit https://tiqdeployed.trackiq.net/WPU.html For a Full list of Programs Licenses. >>%1
ECHO. >>%1
ECHO      Open Source Softare Used on the Device has a copy of the source code co-located. >>%1
ECHO. >>%1
ECHO      Software Package "Versions" compiles a list of Software used and with Open >>%1
ECHO      Source Software also displays the location to the source code. >>%1
exit /b

:BUILD_HELP
ECHO ECHO TrackIQ Setup Disc Help >%1
ECHO ECHO. >>%1
ECHO ECHO Contact Wabtec KnietiX Track IQ Product line Department for More informaiton. >>%1
ECHO ECHO. >>%1
ECHO TYPE "%%~dp0License.txt" >>%1
exit /b