:: For Windows 2000, XP, Server 2003
:: Works in Windows Vista, 7, Server 2008 but may become deprecated in later Windows or Service Packs.
:: Tho it works, it is not modifying the Public Profile Rule. So Network (Work or Public) is Important.
:: If current Profile is Public, then the rules will get applied to Current (public) and All (Domain & Private)
SET ELS=0
ECHO Turning the Firewall ON
netsh firewall set opmode ENABLE >nul
SET /A ELS=%ELS%+%ERRORLEVEL%

ECHO Allowing SMB (Windows file sharing) local subnet access
CALL :Firewallportopen UDP 137 TIQ_NETBIOS_Name
CALL :Firewallportopen UDP 138 TIQ_NETBIOS_Datagram
CALL :Firewallportopen TCP 139 TIQ_NETBIOS_Session
CALL :Firewallportopen TCP 445 TIQ_SMB

ECHO Allowing VQ Server full access
CALL :Firewallportopen TCP 80 TIQ_Web_80
CALL :Firewallportopen TCP 443 TIQ_Web_443
CALL :Firewallportopen TCP 9090 TIQ_Web_9090

ECHO Allowing VNC full access
CALL :Firewallportopen TCP 5900 TIQ_VNC
CALL :Firewallportopen TCP 5800 TIQ_VNC_Web

ECHO Allowing FTP full access
CALL :Firewallportopen TCP 20 TIQ_FTP_Data
CALL :Firewallportopen TCP 21 TIQ_FTP
ECHO Allowing FTP full access (Passive Ports)
CALL :Firewallportopen TCP 50000-50100 TIQ_FTP_Data_Passive

ECHO Allowing UPS Protocol local subnet access
CALL :Firewallportopen TCP 3052 APC_UPS_3052T
CALL :Firewallportopen UDP 3052 APC_UPS_3052U
CALL :Firewallportopen TCP 6547 APC_UPS_6547T
CALL :Firewallportopen UDP 6547 APC_UPS_6547U

ECHO Allowing Internet Time Protocol local subnet access
CALL :Firewallportopen TCP 123 Tardis_K9_InternetTime_T
CALL :Firewallportopen UDP 123 Tardis-K9_InternetTime_U

ECHO Allowing TrackIQ UDP Train Detection Data Gram
CALL :Firewallportopen UDP 4000 TIQ_UDP_Train_Detection_DataGram_Main
CALL :Firewallportopen UDP 4010 TIQ_UDP_Train_Detection_DataGram_Aux

ECHO Allowing Ping full access
rem CALL :Firewallportopen TCP 445 Ping
rem IF NOT %winVER%. == XP. (netsh advfirewall firewall add rule Name=Ping dir=in action=allow protocol=ICMPv4)
IF NOT %winVER%. == XP. (netsh advfirewall firewall set rule Name="Virtual Machine Monitoring (Echo Request - ICMPv4-In)" new enable=yes)


ECHO Allowing Java Through the Firewall
CALL :FirewallAddApp "C:\windows\system32\java.exe" "Java(TM) Platform SE binary"
:: CALL FirewallAddJava

ECHO Allowing TrackIQ Deployed Code Through the Firewall
for /f "tokens=*" %%A in ('dir /b /ad "%~dp0..\..\..\Rail*"') DO for /f "tokens=*" %%B in ('dir /b "%~dp0..\..\..\%%A\*.exe"') DO CALL :FirewallAddApp "%%B" "%%~nB Analysis Software"
for /f "tokens=*" %%B in ('dir /b "%~dp0..\..\..\WCM\*.exe"') DO CALL :FirewallAddApp "%%B" "%%~nB Analysis Software"

ECHO Allowing Remote Desktop access
CALL :Firewallportopen TCP 3389 TIQ_RDP
netsh advfirewall firewall set rule group="remote desktop" new enable=Yes

:: Enable Remote Desktop ( 0 = Enable, 1 = Disable )
REG add "HKLM\SYSTEM\CurrentControlSet\Control\Terminal Server" /f /v "fDenyTSConnections" /d 0 /t REG_DWORD
:: Enable Strong Security (Previously was Disable Strong Security) NLA
REG add "HKLM\SYSTEM\CurrentControlSet\Control\Terminal Server\WinStations\RDP-Tcp" /f /v "UserAuthentication" /d 1 /t REG_DWORD

ECHO.
ECHO A total of %ELS% Firewall rules failed to install
exit /b


:FirewallAddApp
:: Format :FirewallAddApp %1(ProgramWithPath) %2(Name)
IF %1. == . exit /b
IF %2. == . exit /b
:: Clears the Current Error Level
verify >nul
IF NOT DEFINED winVER ECHO ERROR: Parameter winVER was not set! &exit /b
IF %winVER%. == XP. CALL :XPApp %1 %2
IF NOT %winVER%. == XP. CALL :SevenApp %1 %2
exit /b

:XPApp
netsh firewall add allowedprogram program=%1 name=%2 mode=ENABLE scope=ALL profile=ALL  >nul
SET /A ELS=%ELS%+%ERRORLEVEL%
exit /b

:SevenApp
for /F %%a IN ('netsh advfirewall firewall show rule "name=%2"') DO SET FWRL=%%a
IF %FWRL%. == No. (
    netsh advfirewall firewall add rule name=%2 dir=in action=allow program=%1 enable=yes protocol=any
    SET /A ELS=%ELS%+%ERRORLEVEL%
) >nul
IF %FWRL%. == Ok.. (
    netsh advfirewall firewall set rule name=%2 new program=%1
    SET /A ELS=%ELS%+%ERRORLEVEL%
) >nul
rem ECHO rule %3 added... %1=%2
exit /b

:Firewallportopen
:: Format :Firewallportopen %1(Protocol) %2(Port) %3(Name)
IF %1. == . exit /b
IF %2. == . exit /b
IF %3. == . exit /b
:: Clears the Current Error Level
verify >nul

IF NOT DEFINED winVER ECHO ERROR: Parameter winVER was not set! &exit /b
IF %winVER%. == XP. CALL :XPPort %1 %2 %3
IF NOT %winVER%. == XP. CALL :SevenPort %1 %2 %3
exit /b

:XPPort
For /f "delims=- tokens=1,2,3*" %%A IN ("%2") DO (
    IF %%B. == . (
        netsh firewall add portopening protocol=%1 port=%2 name=%3 mode=ENABLE scope=ALL profile=ALL
        SET /A ELS=%ELS%+%ERRORLEVEL%
    ) ELSE (
        for /L %%l IN (%%A,1,%%B) DO (
            netsh firewall add portopening protocol=%1 port=%%l name=%3_%%l mode=ENABLE scope=ALL profile=ALL
            SET /A ELS=%ELS%+%ERRORLEVEL%
            ECHO rule %3_%%l added...
        )
    )
)
exit /b

:SevenPort
for /F %%a IN ('netsh advfirewall firewall show rule "name=%3"') DO SET FWRL=%%a
IF %FWRL%. == No.  netsh advfirewall firewall add rule Name=%3 dir=in action=allow protocol=%1 localport=%2 >nul
IF %FWRL%. == Ok.. netsh advfirewall firewall set rule Name=%3 new localport=%2 >nul
SET /A ELS=%ELS%+%ERRORLEVEL%
SET FWRL=
rem ECHO rule %3 added... %1=%2
exit /b