SET APPRPTH=C:\TrackIQ\APC
IF NOT EXIST %APPRPTH%\. GOTO :EOF
ECHO  Assign IP Address to APC Network Equipment
ECHO.
ECHO  May not work If;
ECHO    APC Equipment was assigned an IP address previously
ECHO    Was connected to a network with a DHCP server
ECHO.
ECHO   WPU IP Address needs to match defined IP Address for this step to work.
ECHO.
SETLOCAL
CALL :LOCAL
CALL :LIPA
ECHO.
CHOICE /N /c ABR /M "Equipment Type; (A) PDU, (B) UPS OR (R) Return: "
IF ERRORLEVEL 1 SET APCIP=%PDUAddress%
IF ERRORLEVEL 2 SET APCIP=%UPSAddress%
IF ERRORLEVEL 3 GOTO APCEND
ECHO Please Enter the twelve digits of the MAC Address (with dash seperation: e.g. 00-C0-B7-)
SET /p INPUT="MAC: "
ARP -s %APCIP% %INPUT%
PING %APCIP% -l 113

REM Assign File to Write Configuration Information to.
SET FILE=%TEMP%\CONFIG.ini

REM Create CONFIG.ini for use by ini Utility to Configure the PDU
    ECHO.>%FILE%
    ECHO [NetworkTCP/IP]>>%FILE%
    ECHO SystemIP=%APCIP%>>%FILE%
    ECHO SubnetMask=255.255.255.0>>%FILE%
    ECHO DefaultGateway=%WPUAddress%>>%FILE%
    ECHO IPv4=enabled>>%FILE%
    ECHO BootMode=Manual>>%FILE%
    ECHO HostName=%EQ%-%NAME% >>%FILE%
    ECHO DomainName=WMA>>%FILE%
    ECHO PortSpeed=Auto>>%FILE%
    ECHO PingResponse=enabled>>%FILE%
    ECHO.>>%FILE%

    ECHO [NetworkEMAIL]>>%FILE%
    ECHO EmailServerName=mail.example.com>>%FILE%
    ECHO EmailFromName=DoNotReply@%COMP%.com>>%FILE%
    ECHO EmailReceiver1Address=RailBAMalerts@trackiq.com.au>>%FILE%
    ECHO EmailReceiver1Route=Local >>%FILE%
    ECHO EmailReceiver1Enable=enabled >>%FILE%
    ECHO EmailReceiver1Format=Long >>%FILE%
    ECHO EmailReceiver1Language=enUs >>%FILE%
    ECHO EmailReceiver1Username=User >>%FILE%
    ECHO. >>%FILE%

    ECHO [NetworkWeb] >>%FILE%
    ECHO Port=80 >>%FILE%
    ECHO Access=enabled >>%FILE%
    ECHO HTTPSPort=443 >>%FILE%
    ECHO ProtocolMode=HTTP >>%FILE%
    ECHO. >>%FILE%

    ECHO [NetworkFTPClient] >>%FILE%
    ECHO RemoteIP=0.0.0.0 >>%FILE%
    ECHO RemoteServer=0.0.0.0 >>%FILE%
    ECHO RemoteUserName=apc >>%FILE%
    ECHO. >>%FILE%

    ECHO [SystemID] >>%FILE%
    ECHO Name=%EQ%-%NAME% >>%FILE%
    ECHO Contact=TrackIQ Adelaide +61 8 8362 5445 >>%FILE%
    ECHO Location=%NAME% >>%FILE%
    ECHO. >>%FILE%

    ECHO [SystemUserManager] >>%FILE%
    ECHO AutoLogout=3 Minutes >>%FILE%
    ECHO AdminUserName=admin >>%FILE%
    ECHO DeviceUserName=%COMP% >>%FILE%
    ECHO DevicePassword=%COMP% >>%FILE%
    ECHO DeviceUserAccess=enabled >>%FILE%
    ECHO ReadOnlyUserName=readonly >>%FILE%
    ECHO ReadOnlyUserAccess=enabled >>%FILE%

    ECHO. >>%FILE%
    ECHO [SystemDate/Time]>>%FILE%
    ECHO DateFormat=dd/mm/yyyy>>%FILE%
    ECHO DSTConfiguration=Disabled>>%FILE%
    ECHO NTPEnable=disabled>>%FILE%
    ECHO NTPPrimaryServer=0.0.0.0>>%FILE%
    ECHO NTPSecondaryServer=0.0.0.0>>%FILE%
    ECHO NTPTimeZone=+00:00>>%FILE%
    ECHO NTPUpdateInterval=336>>%FILE%
    ECHO NTPManualOverride=enabled>>%FILE%

    ECHO. >>%FILE%
    ECHO [SystemPreference] >>%FILE%
    ECHO TemperatureDisplay=C >>%FILE%
    ECHO EventLogDisplay=0 >>%FILE%
    ECHO LanguageDisplay=enUs >>%FILE%
    ECHO. >>%FILE%

    ECHO [SystemLinks] >>%FILE%
    ECHO LinkName1=VIPAC's Web Site >>%FILE%
    ECHO LinkName2=Track IQ's Web Site >>%FILE%
    ECHO LinkName3=RailBAM's Web Site >>%FILE%
    ECHO LinkURL1=http://www.vipac.com.au >>%FILE%
    ECHO LinkURL2=http://www.trackiq.com.au >>%FILE%
    ECHO LinkURL3=http://www.railbam.com.au >>%FILE%
    ECHO LinkDisplay1=VIPAC >>%FILE%
    ECHO LinkDisplay2=TrakIQ >>%FILE%
    ECHO LinkDisplay3=RalBAM >>%FILE%
    ECHO. >>%FILE%

    ECHO [EventLog] >>%FILE%
    ECHO EventLogTimeSelect=All Logs >>%FILE%
    ECHO LogFilterSeverity=0xFF >>%FILE%
    ECHO LogFilterCategories=0xFFFFFFFFFF >>%FILE%
    ECHO EventLogSize=400 >>%FILE%
    ECHO. >>%FILE%

    ECHO [DataLog] >>%FILE%
    ECHO ;    Interval is the Data log recording frequency in seconds. The frequency  >>%FILE%
    ECHO ;    range is from 60 seconds up to 65,535 seconds (18.2 hours). >>%FILE%
    ECHO ;    The default value is 600 seconds(10 minutes). >>%FILE%
    ECHO ;    To change the Log Rotation Password, use the Password keyword.  >>%FILE%
    ECHO ;    i.e., Password=apc  >>%FILE%
    ECHO Interval=600 >>%FILE%
    ECHO LogRotation=enabled >>%FILE%
    ECHO FTPServer=%WPUAddress% >>%FILE%
    ECHO Username=apc >>%FILE%
    ECHO Password=apc >>%FILE%
    ECHO FilePath=/ >>%FILE%
    ECHO FileName=datalog%EQ%.txt >>%FILE%
    ECHO AutoUploadDelay=1 >>%FILE%
    ECHO MaxRetries=1 >>%FILE%
    ECHO FailureWaitTime=10 >>%FILE%
    ECHO DataLogTimeSelect=8 hours >>%FILE%
    ECHO DataLogUniqueFile=disabled >>%FILE%
    ECHO DataLogSize=400 >>%FILE%
    ECHO. >>%FILE%

IF NOT UPS==%EQ% GOTO APCPDU
REM UPS Items ONLY
    ECHO [SmartUPS/Matrix] >>%FILE%
    ECHO HighTransferVoltage=253 >>%FILE%
    ECHO OutputUpperVoltage=253 >>%FILE%
    ECHO RatedOutputVoltage=230 >>%FILE%
    ECHO RatedOutputVoltage=230 >>%FILE%
    ECHO LowTransferVoltage=208 >>%FILE%
    ECHO OutputLowerVoltage=207 >>%FILE%
    ECHO Sensitivity=Normal >>%FILE%
    ECHO ReturnBatteryCapacity=0 >>%FILE%
    ECHO LowBatteryDuration=2 >>%FILE%
    ECHO ShutdownDelay=90 >>%FILE%
    ECHO ReturnDelay=0 >>%FILE%
    ECHO SleepTime=000 >>%FILE%
    ECHO UPSName=%EQ%-%NAME% >>%FILE%
    ECHO AudibleAlarm=Power Fail >>%FILE%
    ECHO SimpleSignalShutdown=disabled >>%FILE%
    ECHO SelfTestSchedule=Every 14 Days >>%FILE%
    ECHO. >>%FILE%

    ECHO [PowerChute] >>%FILE%
    ECHO OnBatteryShutdownBehavior=Reboot On Line Return >>%FILE%
    ECHO CurrentPCNSClientIP=%WPUAddress% >>%FILE%

:APCPDU
IF NOT PDU==%EQ% GOTO APCNEXT
REM PDU Items ONLY
    ECHO [RackPDU] >>%FILE%
    ECHO ColdstartDelay=Immediate >>%FILE%
    ECHO DisplayOrientation=Normal >>%FILE%
    ECHO ISXProtocol=Enabled >>%FILE%
    ECHO ReportingIPAddress=0.0.0.0 >>%FILE%
    ECHO ReportingDelta=1 >>%FILE%
    ECHO. >>%FILE%

    ECHO [RackPDUOutlet] >>%FILE%
    ECHO Name1=RailBAM_WPU >>%FILE%
    ECHO Name2=WCM_WPU >>%FILE%
    ECHO Name3=MARF >>%FILE%
    ECHO Name4=SCU >>%FILE%
    ECHO Name5=WIE_Power_Supply >>%FILE%
    ECHO Name6=Network Switch >>%FILE%
    ECHO Name7=Communications >>%FILE%
    ECHO Name8=KVM >>%FILE%

    ECHO PowerOnDelay1=30 Seconds >>%FILE%
    ECHO PowerOnDelay2=30 Seconds >>%FILE%
    ECHO PowerOnDelay3=Immediate >>%FILE%
    ECHO PowerOnDelay4=Immediate >>%FILE%
    ECHO PowerOnDelay5=Immediate >>%FILE%
    ECHO PowerOnDelay6=Immediate >>%FILE%
    ECHO PowerOnDelay7=Immediate >>%FILE%
    ECHO PowerOnDelay8=Immediate >>%FILE%
    ECHO PowerOffDelay1=Immediate >>%FILE%
    ECHO PowerOffDelay2=Immediate >>%FILE%
    ECHO PowerOffDelay3=Immediate >>%FILE%
    ECHO PowerOffDelay4=Immediate >>%FILE%
    ECHO PowerOffDelay5=Immediate >>%FILE%
    ECHO PowerOffDelay6=Never >>%FILE%
    ECHO PowerOffDelay7=Never >>%FILE%
    ECHO PowerOffDelay8=Never >>%FILE%
    ECHO RebootDuration1=30 Seconds >>%FILE%
    ECHO RebootDuration2=30 Seconds >>%FILE%
    ECHO RebootDuration3=5 Seconds >>%FILE%
    ECHO RebootDuration4=5 Seconds >>%FILE%
    ECHO RebootDuration5=30 Seconds >>%FILE%
    ECHO RebootDuration6=5 Seconds >>%FILE%
    ECHO RebootDuration7=5 Seconds >>%FILE%
    ECHO RebootDuration8=5 Seconds >>%FILE%
    ECHO OutletLink1=http:/// >>%FILE%
    ECHO OutletLink2=http:/// >>%FILE%
    ECHO OutletLink3=http:/// >>%FILE%
    ECHO OutletLink4=http:/// >>%FILE%
    ECHO OutletLink5=http:/// >>%FILE%
    ECHO OutletLink6=http:/// >>%FILE%
    ECHO OutletLink7=http:/// >>%FILE%
    ECHO OutletLink8=http:/// >>%FILE%
    ECHO. >>%FILE%

    ECHO [OutletUserManager] >>%FILE%
    ECHO User1Status=Enabled >>%FILE%
    ECHO User1Name=power >>%FILE%
    ECHO User1Password=power >>%FILE%
    ECHO User1Outlets=Outlets[1,2,3,4,5] >>%FILE%
    ECHO User1Description=Power Outlet User >>%FILE%

:APCNEXT

REM Return IP address to the correct device.
    REM Create upload_list.txt for ini Utility.
    SET FILE=%TEMP%\upload_list.txt
    ECHO SystemIP=%APCIP% >%FILE%
    ECHO IniFileName=CONFIG.ini >>%FILE%
    ECHO SystemUserName=apc >>%FILE%
    ECHO SystemPassword=apc >>%FILE%

    REM Create AutoINPUT for ini Utility.
    SET FILE=%TEMP%\AutoINPUT
    ECHO 1 >%FILE%
    ECHO 1 >>%FILE%
    ECHO 3 >>%FILE%
    ECHO.  >>%FILE%

   REM Copy ini Utility to same folder
   COPY %APPRPTH%\iniutil.exe %TEMP%\iniutil.exe
   COPY %APPRPTH%\winftp32.dll %TEMP%\winftp32.dll
REM   COPY ..\COMM\APC\AutoINPUT %TEMP%\AutoINPUT

   REM Run ini Utility from Temp Folder
   pushd %TEMP%
   iniutil.exe <AutoINPUT
   popd

   REM Clean-up ini Utility from Temp Folder
   DEL %TEMP%\iniutil.exe
   DEL %TEMP%\winftp32.dll
   DEL %TEMP%\AutoINPUT
   DEL %TEMP%\upload_list.txt
REM   DEL %TEMP%\CONFIG.ini


ECHO.
ECHO.
ECHO The Webpage Has Been Loaded, please use admin for User Name and apc for Password
ECHO and change the IP address and subnet mask to match the Site Configuration.
START http://%APCIP%/

:APCEND
ENDLOCAL
exit /b



:local
SET COMP=TrackIQ
REM Company Name.

SET NAME=Pre-Site
REM Site Name.

IF EXIST %TEMP%\LOCAL.BAT CALL %TEMP%\LOCAL.BAT
REM Check if this Site has configuration settings
IF DEFINED BASE CALL :localvariables
IF NOT DEFINED WPUAddress SET WPUAddress=192.168.1.11
IF NOT DEFINED PDUAddress SET PDUAddress=192.168.1.12
IF NOT DEFINED UPSAddress SET UPSAddress=192.168.1.13
exit /b

:localvariables
IF NOT DEFINED PCIP exit /b
IF NOT DEFINED WPUAddress SET WPUAddress=%BASE%%PCIP%
IF DEFINED PCIP SET /A PCIP=%PCIP%+1
IF NOT DEFINED PDUAddress SET PDUAddress=%BASE%%PCIP%
IF DEFINED PCIP SET /A PCIP=%PCIP%+1
IF NOT DEFINED UPSAddress SET UPSAddress=%BASE%%PCIP%
exit /b

:LIPA
SETLOCAL
SET ip_Detect_Error=FALSE
SET TstBASE=127.0.0.
SET TstIP=1
ping -n 1 -i 1 -4 %COMPUTERNAME% |find "Reply from" >%TEMP%\tmpIP.txt
FOR /F "tokens=3,4,5,6,7* delims=.: " %%a in (%TEMP%\tmpIP.txt) DO SET TstIP=%%a.%%b.%%c.%%d
REM Clean Up
del %TEMP%\tmpIP.txt
REM Check False IP Address Conditions
IF 127.0.0.1 == %TstIP% SET ip_Detect_Error=TRUE
IF NOT TRUE==%ip_Detect_Error% (
    IF %WPUAddress%.==%TstIP%. (
        ECHO   IP Address For the WPU is                   : %WPUAddress%
    ) ELSE (
        ECHO   IP Address For the WPU Needs to be changed  : %WPUAddress%
    )
) ELSE (
        ECHO   IP Address Should be configured as          : %WPUAddress%
)
ENDLOCAL
exit /b