:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::            Compress and Process Batch Script              ::
::                         V1.2                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2020/03/31                           ::
::                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@echo off
setlocal ENABLEDELAYEDEXPANSION

:: Find *.cmd file to use largest as the main script entry.
FOR /F "tokens=*" %%a in ('DIR /B /OS "%~dp0*.cmd"') DO SET FILE=%%a
:: Read the Parameter In from the main script entry.
FOR /F "tokens=1* delims==" %%a in ('findstr /B /C:"SET TRNROOT=" "%~dp0%FILE%"') DO SET TRNROOT=%%b
:: Enter Parameters below; (If above Fails)
::===============================================================
:: Configuration Parameters
IF NOT DEFINED TRNROOT SET TRNROOT=D:\Server
IF NOT DEFINED TrainListDIR SET TrainListDIR=%~dp0trainlist
:: Configure a Defined Site Name to be used Instead of the Auto Detected Name from Analysis.log
:: SET SiteAcronymStatic=DefinedSiteName

::===============================================================
::SETUP Parameters needed
cd /d "%TRNROOT%"
IF NOT EXIST "%TrainListDIR%\." MKDIR "%TrainListDIR%"
IF NOT EXIST "%~dp0log\." mkdir "%~dp0log"
:: Change to root of relative Path DIR. (for 7zip to add the path).

:: Main_Loop --
ECHO %TIME% Start  Loop, Checking for Trains... | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"
:: Detect if Comprocess is named Comprocess.D (drive letter) to define the Drive to monitor.
CALL :FolderNameDriveLetterDetect
IF DEFINED DRV_TO_MONITOR SET TRNROOT=%DRV_TO_MONITOR%%TRNROOT:~1%

:: Get lastest list of trains to work on, then find entries where the Timestamp has chagned since previously compressed and Delete the %TrainListDIR% entry. Hence if deleted it would be copied again by the regular Com Process..
FOR /f "tokens=* delims=" %%A IN ('DIR /B "%TRNROOT%\trainlist"') DO (
    IF EXIST "%TrainListDIR%\%%A.done" (
        ECHO !TIME! Found %%A.done | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"
        FOR /F "tokens=*" %%M in ('DIR "%TrainListDIR%\%%A.done" ^|findstr "%%A"') DO SET trainlistM=%%M
        FOR /F "tokens=*" %%S in ('DIR "%TRNROOT%\trainlist\%%A" ^|findstr "%%A"') DO SET trainlistS=%%S
        REM first characters Between 21 and 55 (picked 30) will match (date - time - size - filename.) then the file extention is different.
        IF NOT "!trainlistM:~0,30!"=="!trainlistS:~0,30!" (DEL "%TrainListDIR%\%%A.done" && ECHO !TIME! Updated File %%A.done Deleted. | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log")
    )
)
endlocal
goto :eof

:: Tests path variables to detect only parent folder.
:SHIFTVARS
SET ParentFolder=%1
SET RunBatchTest=%2
IF "%RunBatchTest%"=="" exit /b
SHIFT
GOTO :SHIFTVARS
exit /b

:FolderNameDriveLetterDetect
:: Parent Folder Name Detection
SET RUNPATH=%~dp0
SET RUNPATH=%RUNPATH: =#%
CALL :SHIFTVARS %RUNPATH:\= %
SET ParentFolder=%ParentFolder:#= %
:: Assign "DRV_TO_MONITOR" based on this folder name (First Charator after. IF EXISTS)
for /f "tokens=2 delims=." %%A IN ("%ParentFolder%") DO IF EXIST "%%A:\." SET DRV_TO_MONITOR=%%A
IF DEFINED DRV_TO_MONITOR SET DRV_TO_MONITOR=%DRV_TO_MONITOR:~0,1%
exit /b
