:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::            Compress and Process Batch Script              ::
::                         V6.9                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2023/11/27                           ::
::                                                           ::
::      Makes use of 7z + ffmpeg command line utilities      ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@echo off
setlocal ENABLEDELAYEDEXPANSION
:: Enter Configuration Parameters below;
::===============================================================
:: Primary Source Locations
IF NOT DEFINED TRNROOT SET TRNROOT=D:\Server
IF NOT DEFINED DiskPurgeList SET DiskPurgeList=C:\TrackIQ\DiskPurgeBatch\PurgeList

:: Change the FTDIR Paths if you need more than one destination.
IF NOT DEFINED FTF1DIR SET FTF1DIR=D:\Server\Share\FleetOne
IF NOT DEFINED FTF1ArtefactsDIR SET FTF1ArtefactsDIR=D:\Server\Share\FleetOne-Artefacts

:: The Deafult Trainlist Directory
IF NOT DEFINED TrainListDIR SET TrainListDIR=%~dp0trainlist

:: The Following Parameters are Optionally set;

:: SET FTDiagnoticsArtefactsDIR=D:\Server\Share\Diagnostics-Artefacts

:: SET FTF1DIRCPY=D:\Server\Share\FleetOneCOPY
:: SET FTF1ArtefactsDIRCPY=D:\Server\Share\FleetOneCOPY-Artefacts
:: SET FTDiagnoticsArtefactsDIRCPY=D:\Server\Share\DiagnosticsCOPY-Artefacts

:: SET FTF1DIRCPY2=D:\Server\Share\FleetOneCOPY2
:: SET FTF1ArtefactsDIRCPY2=D:\Server\Share\FleetOneCOPY2-Artefacts
:: SET FTDiagnoticsArtefactsDIRCPY2=D:\Server\Share\DiagnosticsCOPY2-Artefacts

:: To Enable Local USB Archive of Tagged Trains define LOCALUSBARCHIVE with a drive letter
:: SET LOCALUSBARCHIVE=E:

:: To prevent rawres_*.MAT files to be transfered to FleetOne. Define REDUCEF1Artefacts to skip sending rawres_*.MAT files to FleetOne
:: SET REDUCEF1Artefacts=AnyValue
:: To Store More trains on Disk, Compress RAW DAT Files. (Feature migrated away from Analysis software.) Define CompressRAWDatFiles to compress
:: SET CompressRAWDatFiles=AnyValue
:: To Reduce the recorded video file in a compatiable format, specify the MJPEG Quality
:: SET CompressAVIFileQuality=90

:: ArcInfra historical replacement of VQServer Web Crawler tool
:: SET ARCInfraRAMS_ARCH=D:\server\Share\Ramsarch
:: SET ARCHAcronym=10.254.210.35

:: Configure a Defined Site Name to be used Instead of the Auto Detected Name from Analysis.log
:: SET SiteAcronymStatic=DefinedSiteName


::===============================================================
:: SETUP Parameters needed
IF NOT EXIST "%FTF1DIR%" MKDIR "%FTF1DIR%"
IF NOT EXIST "%FTF1ArtefactsDIR%" MKDIR "%FTF1ArtefactsDIR%"
IF DEFINED FTDiagnoticsArtefactsDIR IF NOT EXIST "%FTDiagnoticsArtefactsDIR%" MKDIR "%FTDiagnoticsArtefactsDIR%"
IF NOT EXIST "%TRNROOT%\trains" MKDIR "%TRNROOT%\trains"
IF DEFINED FTF1DIRCPY IF NOT EXIST "%FTF1DIRCPY%" MKDIR "%FTF1DIRCPY%"
IF DEFINED FTF1ArtefactsDIRCPY IF NOT EXIST "%FTF1ArtefactsDIRCPY%" MKDIR "%FTF1ArtefactsDIRCPY%"
IF DEFINED FTDiagnoticsArtefactsDIRCPY IF NOT EXIST "%FTDiagnoticsArtefactsDIRCPY%" MKDIR "%FTDiagnoticsArtefactsDIRCPY%"
IF DEFINED FTF1DIRCPY2 IF NOT EXIST "%FTF1DIRCPY2%" MKDIR "%FTF1DIRCPY2%"
IF DEFINED FTF1ArtefactsDIRCPY2 IF NOT EXIST "%FTF1ArtefactsDIRCPY2%" MKDIR "%FTF1ArtefactsDIRCPY2%"
IF DEFINED FTDiagnoticsArtefactsDIRCPY2 IF NOT EXIST "%FTDiagnoticsArtefactsDIRCPY2%" MKDIR "%FTDiagnoticsArtefactsDIRCPY2%"
IF NOT EXIST "%~dp0ffmpeg.exe" SET CompressAVIFileQuality=

cd /d "%TRNROOT%"
IF NOT EXIST "%TrainListDIR%\." MKDIR "%TrainListDIR%"

:: Generate Trainlist if not existant.
:: IF NOT EXIST %TRNROOT%\trainlist\. CALL %~dp0GenerateTrainlist.bat

:: Change to root of relative Path DIR. (for 7zip to add the path).
:: Main_Loop --
ECHO %TIME% Checking %TRNROOT%\trainlist for new entries...
:: Get lastest list of trains to work on, if file not exist, copy. Hence if previously deleted it would be copied again.
IF EXIST "%TRNROOT%\trainlist\." (
    FOR /f "tokens=* delims=" %%A IN ('DIR /B "%TRNROOT%\trainlist"') DO (
      IF NOT EXIST "%TrainListDIR%\%%A.do*" IF NOT EXIST "%TrainListDIR%\%%A.done" (copy /Y "%TRNROOT%\trainlist\%%A" "%TrainListDIR%\%%A.do" >nul && ECHO !TIME! File %%A.do Copied.)
    )
) ELSE (
    REM Tokens Needs to match the TRNROOT path used!
    for /f "tokens=7,8,9* delims=\" %%a in ('dir /ad /s /b "%TRNROOT%\trains\"') do if not "%%c"=="" if exist "%TRNROOT%\trains\%%a\%%b\%%c\*.gz" (echo.%%a_%%b_%%c 2>"%TrainListDIR%\%%a_%%b_%%c.do")
)
:: Check for trains that require a re-do for compression. The retry (.doX) is Skipped if the Hour (X) is the same as the current time. (i.e. X:43:23.00)
for /l %%Z in (0,1,9) DO (
  IF EXIST "%TrainListDIR%\*.do%%Z" (
    SET NOWTIMECOMPARE=!TIME:~-10,1!
    IF NOT "%%Z"=="!NOWTIMECOMPARE!" for /f "tokens=* delims=" %%a in ('dir /b "%TrainListDIR%\*.do%%Z"') do ren "%TrainListDIR%\%%a" "%%~na.do" && ECHO !TIME! File %%~na.do Retry
  )
)
ECHO %TIME% Clearing trainlist%SiteAcronym% of Purged Trains...
:: Remove trains from local trainlist that have been Purged from the Disk.
IF EXIST "%DiskPurgeList%\." (
  FOR /f "tokens=* delims=" %%A IN ('DIR /B "%DiskPurgeList%"') DO (
    IF EXIST "%TrainListDIR%\%%A.do" (DEL "%TrainListDIR%\%%A.do" && ECHO !TIME! File %%A.do Purged.)
    IF EXIST "%TrainListDIR%\%%A.done" (DEL "%TrainListDIR%\%%A.done" && ECHO !TIME! File %%A.done Purged.)
  )
) ELSE (
  REM Old Method has had situations where the system would report the path dosn't exist but it dose. Hence this re-triggers the trains to re transfer.
  FOR /F "tokens=1,2,3,4* delims=_. " %%a in ('DIR /B "%TrainListDIR%\*.done"') DO IF EXIST "%TRNROOT%\." IF NOT EXIST "%TRNROOT%\Trains\%%a\%%b\%%c\." (DEL "%TrainListDIR%\%%a_%%b_%%c.done" && ECHO !TIME! File %%a_%%b_%%c.done Deleted.)
)

ECHO %TIME% Processing Trains...
:: Compression loop of directories to work on with "do" Files.
FOR /F "tokens=1,2,3,4,5* delims=_. " %%a in ('DIR /B "%TrainListDIR%\*.do" 2^>nul') DO (
  REM Allow the Use of a Staticly Defined SiteAcronym for Backwards Compatability
  IF DEFINED SiteAcronymStatic SET SiteAcronym=%SiteAcronymStatic%
  IF EXIST Trains\%%a\%%b\%%c\analysis.log (
    REM Find Site Name String in the analysis.log file.
    IF NOT DEFINED SiteAcronymStatic for /f "tokens=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,*" %%H IN ('findstr /B /c:"********" Trains\%%a\%%b\%%c\analysis.log') DO (
      SET SH=%%H
      SET SI=%%I
      SET SJ=%%J
      SET SK=%%K
      SET SL=%%L
      SET SM=%%M
      SET SN=%%N
      SET SO=%%O
      SET SP=%%P
      SET SQ=%%Q
      SET SR=%%R
      SET SS=%%S
      SET ST=%%T
      SET SU=%%U
      SET SV=%%V
      SET SW=%%W
      SET SX=%%X
      SET SY=%%Y
      SET SZ=%%Z
      SET SH=!SH:~0,1!
      SET SI=!SI:~0,1!
      SET SJ=!SJ:~0,1!
      SET SK=!SK:~0,1!
      SET SL=!SL:~0,1!
      SET SM=!SM:~0,1!
      SET SN=!SN:~0,1!
      SET SO=!SO:~0,1!
      SET SP=!SP:~0,1!
      SET SQ=!SQ:~0,1!
      SET SR=!SR:~0,1!
      SET SS=!SS:~0,1!
      SET ST=!ST:~0,1!
      SET SU=!SU:~0,1!
      SET SV=!SV:~0,1!
      SET SW=!SW:~0,1!
      SET SX=!SX:~0,1!
      SET SY=!SY:~0,1!
      SET SZ=!SZ:~0,1!
      IF "*"=="!SJ!" SET SiteAcronym=%%I
      IF "*"=="!SK!" SET SiteAcronym=%%I%%J
      IF "*"=="!SL!" SET SiteAcronym=%%I%%J%%K
      IF "*"=="!SM!" SET SiteAcronym=%%I%%J%%K%%L
      IF "*"=="!SN!" SET SiteAcronym=%%I%%J%%K%%L%%M
      IF "*"=="!SO!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N
      IF "*"=="!SP!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O
      IF "*"=="!SQ!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P
      IF "*"=="!SR!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q
      IF "*"=="!SS!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R
      IF "*"=="!ST!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S
      IF "*"=="!SU!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T
      IF "*"=="!SV!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T%%U
      IF "*"=="!SW!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T%%U%%V
      IF "*"=="!SX!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T%%U%%V%%W
      IF "*"=="!SY!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T%%U%%V%%W%%X
      IF "*"=="!SZ!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T%%U%%V%%W%%X%%Y
    )
    REM Find the System Sensor Type in the analysis.log file Used for Diagnostics Files and 7z Filename generation but not end folder name.
    for /f "tokens=*" %%H IN ('findstr /c:"-Algorithms" Trains\%%a\%%b\%%c\analysis.log') DO (
      for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "RailBAM-"') DO SET Sensor=RailBAM
      for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "RailSQAD-"') DO SET Sensor=RailSQAD
      for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "RailTAG-"') DO SET Sensor=RailTAG
      for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "RailCAMTag-"') DO SET Sensor=RailTAG
      for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "RailCAMThermal-"') DO SET Sensor=RailCAMThermal
      for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "NSMON-"') DO SET Sensor=RailNSMON
      for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "WCM-"') DO SET Sensor=WCM2
      for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "RailHBWD-"') DO SET Sensor=RailHBWD
    )
  )
  REM Support Vision System types
  IF EXIST Trains\%%a\%%b\%%c\BGM*.gz SET Sensor=BGM
  IF EXIST Trains\%%a\%%b\%%c\WPM*.gz SET Sensor=WPM
  IF EXIST Trains\%%a\%%b\%%c\BIM*.gz SET Sensor=BIM

  REM Should anything go wrong, Mark as Faulty and Continue.
  IF NOT DEFINED Sensor ECHO !TIME! ERROR Detecting Sensor in \%%a\%%b\%%c\ &SET Sensor=ERROR
  IF NOT DEFINED SiteAcronym ECHO !TIME! ERROR Detecting SiteAcronym in \%%a\%%b\%%c\ &SET SiteAcronym=Faulty
  REM Define Variables and Create Files for Processing.
  SET DiagnosticsAcronym=!SiteAcronym!!Sensor!
  IF NOT EXIST "%~dp0#!SiteAcronym!#" ECHO. 2>"%~dp0#!SiteAcronym!#"
  IF NOT EXIST "%~dp0#!DiagnosticsAcronym!#" ECHO. 2>"%~dp0#!DiagnosticsAcronym!#"
  REM Start from a Defined Error Count Each Loop
  Ver >nul
  SET ERRORCOUNT=0

  REM FTF1DIR  (FleetOne Data Files)
  REM _F1Results Compress Results into one Archive (Use Same Filename for any results files going forward)  (Typically only one Type will exist) - Ignore CSV files for RailCAM system type.
  IF EXIST Trains\%%a\%%b\%%c\*.tab "%~dp07z.exe" a -y "%FTF1DIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_F1Results.7z" "%~dp0#!SiteAcronym!#" "Trains\%%a\%%b\%%c\*.tab"
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
  IF NOT "RailTAG"=="!Sensor!" IF EXIST Trains\%%a\%%b\%%c\*.csv "%~dp07z.exe" a -y "%FTF1DIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_F1Results.7z" "%~dp0#!SiteAcronym!#" "Trains\%%a\%%b\%%c\*.csv"
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
  IF EXIST Trains\%%a\%%b\%%c\*.gz "%~dp07z.exe" a -sdel -y "%FTF1DIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_F1Results.7z" "%~dp0#!SiteAcronym!#" "Trains\%%a\%%b\%%c\*.gz"
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
  IF NOT EXIST "%~dp0#!SiteAcronym!#" ECHO. 2>"%~dp0#!SiteAcronym!#"
  IF DEFINED FTF1DIRCPY IF EXIST "%FTF1DIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_F1Results.7z" COPY "%FTF1DIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_F1Results.7z" "%FTF1DIRCPY%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_F1Results.7z"
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
  IF DEFINED FTF1DIRCPY2 IF EXIST "%FTF1DIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_F1Results.7z" COPY "%FTF1DIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_F1Results.7z" "%FTF1DIRCPY2%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_F1Results.7z"
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!

  REM FTF1ArtefactsDIR (FleetOne Artefacts Files)
  REM _JPG Compress RailCAM type JPG files into one Archive for Artefacts transfer.
  IF EXIST Trains\%%a\%%b\%%c\*__*.jpg "%~dp07z.exe" a -y "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_JPG.7z" "%~dp0#!SiteAcronym!#" "Trains\%%a\%%b\%%c\*__*.jpg"
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
  IF DEFINED FTF1ArtefactsDIRCPY IF EXIST "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_JPG.7z" COPY "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_JPG.7z" "%FTF1ArtefactsDIRCPY%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_JPG.7z"
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
  IF DEFINED FTF1ArtefactsDIRCPY2 IF EXIST "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_JPG.7z" COPY "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_JPG.7z" "%FTF1ArtefactsDIRCPY2%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_JPG.7z"
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
  REM _WAV Compress RailBAM type WAV files into one Archive for Artefacts transfer.
  IF EXIST Trains\%%a\%%b\%%c\*.wav "%~dp07z.exe" a -y "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_WAV.7z" "%~dp0#!SiteAcronym!#" "Trains\%%a\%%b\%%c\*.wav"
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
  IF DEFINED FTF1ArtefactsDIRCPY IF EXIST "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_WAV.7z" COPY "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_WAV.7z" "%FTF1ArtefactsDIRCPY%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_WAV.7z"
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
  IF DEFINED FTF1ArtefactsDIRCPY2 IF EXIST "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_WAV.7z" COPY "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_WAV.7z" "%FTF1ArtefactsDIRCPY2%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_WAV.7z"
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
  REM _PNG Compress PNG files into one Archive.
  SET FILES_COUNT=0
  IF EXIST Trains\%%a\%%b\%%c\L_*.png SET /A FILES_COUNT=!FILES_COUNT! + 1
  IF EXIST Trains\%%a\%%b\%%c\R_*.png SET /A FILES_COUNT=!FILES_COUNT! + 1
  IF EXIST Trains\%%a\%%b\%%c\L?_*.png SET /A FILES_COUNT=!FILES_COUNT! + 1
  IF EXIST Trains\%%a\%%b\%%c\R?_*.png SET /A FILES_COUNT=!FILES_COUNT! + 1
  IF NOT "!FILES_COUNT!"=="0" "%~dp07z.exe" a -y "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_PNG.7z" "%~dp0#!SiteAcronym!#" "Trains\%%a\%%b\%%c\L_*.png" "Trains\%%a\%%b\%%c\R_*.png" "Trains\%%a\%%b\%%c\L?_*.png" "Trains\%%a\%%b\%%c\R?_*.png"
  IF DEFINED FTF1ArtefactsDIRCPY IF EXIST "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_PNG.7z" COPY "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_PNG.7z" "%FTF1ArtefactsDIRCPY%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_PNG.7z"
  IF DEFINED FTF1ArtefactsDIRCPY2 IF EXIST "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_PNG.7z" COPY "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_PNG.7z" "%FTF1ArtefactsDIRCPY2%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_PNG.7z"
  REM Compress rawres_*.mat files into a Archive.
  IF NOT "RailCAM"=="!SENSOR:~0,7!" IF NOT DEFINED REDUCEF1Artefacts IF EXIST Trains\%%a\%%b\%%c\rawres_*.mat "%~dp07z.exe" a -y "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_MAT.7z" "%~dp0#!SiteAcronym!#" "Trains\%%a\%%b\%%c\rawres_*.mat"
  IF DEFINED FTF1ArtefactsDIRCPY IF EXIST "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_MAT.7z" COPY "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_MAT.7z" "%FTF1ArtefactsDIRCPY%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_MAT.7z"
  IF DEFINED FTF1ArtefactsDIRCPY2 IF EXIST "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_MAT.7z" COPY "%FTF1ArtefactsDIR%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_MAT.7z" "%FTF1ArtefactsDIRCPY2%\%%a-%%b-%%c#!SiteAcronym!!Sensor!#_MAT.7z"

  REM FTDiagnoticsArtefactsDIR (Diagnostics Artefacts Files)
  IF DEFINED FTDiagnoticsArtefactsDIR (
   REM _MAT Compress *.mat files into a Archive.
   SET FILES_COUNT=0
   IF NOT "RailCAM"=="!SENSOR:~0,7!" IF EXIST Trains\%%a\%%b\%%c\rawres_*.mat SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF NOT "RailCAM"=="!SENSOR:~0,7!" IF EXIST Trains\%%a\%%b\%%c\whldets*.mat SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF EXIST Trains\%%a\%%b\%%c\*_Updated.mat SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF NOT "!FILES_COUNT!"=="0" "%~dp07z.exe" a -y "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_MAT.7z" "%~dp0#!DiagnosticsAcronym!#" "Trains\%%a\%%b\%%c\rawres_*.mat" "Trains\%%a\%%b\%%c\whldets*.mat" "Trains\%%a\%%b\%%c\*_Updated.mat"
   SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
   IF DEFINED FTDiagnoticsArtefactsDIRCPY IF EXIST "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_MAT.7z" COPY "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_MAT.7z" "%FTDiagnoticsArtefactsDIRCPY%\%%a-%%b-%%c#!DiagnosticsAcronym!#_MAT.7z"
   IF DEFINED FTDiagnoticsArtefactsDIRCPY2 IF EXIST "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_MAT.7z" COPY "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_MAT.7z" "%FTDiagnoticsArtefactsDIRCPY2%\%%a-%%b-%%c#!DiagnosticsAcronym!#_MAT.7z"
   REM _FIG_PNG Compress PNG and FIG files into one Archive.
   SET FILES_COUNT=0
   IF EXIST Trains\%%a\%%b\%%c\*Chk_*.png SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF EXIST Trains\%%a\%%b\%%c\ValidationCertificate*.png SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF EXIST Trains\%%a\%%b\%%c\AlignWhls.png SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF EXIST Trains\%%a\%%b\%%c\Hndllaser*.png SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF EXIST Trains\%%a\%%b\%%c\sample_rates*.png SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF EXIST Trains\%%a\%%b\%%c\*.fig SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF NOT "!FILES_COUNT!"=="0" "%~dp07z.exe" a -y "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_FIG_PNG.7z" "%~dp0#!DiagnosticsAcronym!#" "Trains\%%a\%%b\%%c\*Chk_*.png" "Trains\%%a\%%b\%%c\ValidationCertificate*.png" "Trains\%%a\%%b\%%c\AlignWhls.png" "Trains\%%a\%%b\%%c\Hndllaser*.png" "Trains\%%a\%%b\%%c\*.fig" "Trains\%%a\%%b\%%c\sample_rates*.png"
   IF DEFINED FTDiagnoticsArtefactsDIRCPY IF EXIST "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_FIG_PNG.7z"  COPY "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_FIG_PNG.7z" "%FTDiagnoticsArtefactsDIRCPY%\%%a-%%b-%%c#!DiagnosticsAcronym!#_FIG_PNG.7z"
   IF DEFINED FTDiagnoticsArtefactsDIRCPY2 IF EXIST "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_FIG_PNG.7z"  COPY "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_FIG_PNG.7z" "%FTDiagnoticsArtefactsDIRCPY2%\%%a-%%b-%%c#!DiagnosticsAcronym!#_FIG_PNG.7z"
   REM _HTM_LOG_TAG Compress intermediate (text Based) files into one Archive.
   SET FILES_COUNT=0
   IF EXIST Trains\%%a\%%b\%%c\*.log SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF EXIST Trains\%%a\%%b\%%c\TMR*.htm SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF EXIST Trains\%%a\%%b\%%c\*.tag SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF EXIST Trains\%%a\%%b\%%c\*.txt SET /A FILES_COUNT=!FILES_COUNT! + 1
   IF NOT "!FILES_COUNT!"=="0" "%~dp07z.exe" a -y "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_HTM_LOG_TAG.7z" "%~dp0#!DiagnosticsAcronym!#" "Trains\%%a\%%b\%%c\*.log" "Trains\%%a\%%b\%%c\TMR*.htm" "Trains\%%a\%%b\%%c\*.tag" "Trains\%%a\%%b\%%c\*.txt" -xr^^!SMS*.txt
   IF DEFINED FTDiagnoticsArtefactsDIRCPY IF EXIST "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_HTM_LOG_TAG.7z" COPY "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_HTM_LOG_TAG.7z" "%FTDiagnoticsArtefactsDIRCPY%\%%a-%%b-%%c#!DiagnosticsAcronym!#_HTM_LOG_TAG.7z"
   IF DEFINED FTDiagnoticsArtefactsDIRCPY2 IF EXIST "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_HTM_LOG_TAG.7z" COPY "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#!DiagnosticsAcronym!#_HTM_LOG_TAG.7z" "%FTDiagnoticsArtefactsDIRCPY2%\%%a-%%b-%%c#!DiagnosticsAcronym!#_HTM_LOG_TAG.7z"
  )

  REM Only mark the trainlist file Done if no errors occured during compression of all the results. If Error rename with the .do"tens" past the hour to mark for next re-try   i.e. do3 = about 3 mins past the next hour.
  IF !ERRORCOUNT! == 0 (ren "%TrainListDIR%\%%a_%%b_%%c.do" "%%a_%%b_%%c.done" && ECHO !TIME! File %%a_%%b_%%c.do is now %%a_%%b_%%c.done) ELSE (ren "%TrainListDIR%\%%a_%%b_%%c.do" "%%a_%%b_%%c.do!TIME:~-10,1!" &&ECHO !TIME! !ERRORCOUNT! Processing Errors, File %%a_%%b_%%c.do is now %%a_%%b_%%c.do!TIME:~-10,1!)

  IF DEFINED CompressRAWDatFiles (
   REM _DAT Compress *.dat files into a Archive in the train folder.
   pushd Trains\%%a\%%b\%%c
     IF EXIST *.dat Start "Compress DAT to %%a_%%b_%%c_#!SiteAcronym!#_RAW_DAT.7z" /LOW /WAIT /MIN "%~dp07z.exe" a -sdel -y %%a_%%b_%%c_#!SiteAcronym!#_RAW_DAT.7z *.dat
   popd
  )
  
  IF DEFINED CompressAVIFileQuality (
   REM  Compress RAW *.avi files into mjpeg *.avi file in the train folder.
   for /f "tokens=*" %%M IN ('dir /b "Trains\%%a\%%b\%%c\*.avi"') DO (
     SET FFMPEGSTART=!TIME!
     IF NOT EXIST "Trains\%%a\%%b\%%c\%%~nM-qsv.Done" "%~dp0ffmpeg.exe" -init_hw_device qsv=qsv:hw -hwaccel qsv -hwaccel_output_format qsv -v verbose -i "Trains\%%a\%%b\%%c\%%M" -c:v mjpeg_qsv -global_quality %CompressAVIFileQuality% "Trains\%%a\%%b\%%c\%%~nM-qsv.avi"&&ECHO.2>"Trains\%%a\%%b\%%c\%%~nM-qsv.done"&&move /y "Trains\%%a\%%b\%%c\%%~nM-qsv.avi" "Trains\%%a\%%b\%%c\%%M" 
     ECHO !FFMPEGSTART! - !TIME! AVI: %%M Compressed at %CompressAVIFileQuality%%% Quality %%~zM
   )
  )
  
  REM ARCInfra RAMS_ARCH Proces (replaces VQServer crawler by ArcInfra)
  IF DEFINED ARCHAcronym IF NOT EXIST "%~dp0#!ARCHAcronym!#" ECHO. 2>"%~dp0#!ARCHAcronym!#"
  IF DEFINED ARCInfraRAMS_ARCH (
    SET FILES_COUNT=0
    IF EXIST Trains\%%a\%%b\%%c\TMR*.htm SET /A FILES_COUNT=!FILES_COUNT! + 1
    IF NOT "!FILES_COUNT!"=="0" "%~dp07z.exe" a -y "%ARCInfraRAMS_ARCH%\%%a-%%b-%%c#!ARCHAcronym!#_HTM.7z" "%~dp0#!ARCHAcronym!#" "Trains\%%a\%%b\%%c\TMR*.htm" -xr^^!SMS*.txt
  )
  IF DEFINED LOCALUSBARCHIVE (
    REM Function to Keep a Archived Copy of RAW tagged Train data on External Disk
    ECHO !TIME! Archiving Train to USB !LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c
    pushd Trains\%%a\%%b\%%c
    REM Build Train Directory on Archive Drive
     IF NOT EXIST "!LOCALUSBARCHIVE!\!SiteAcronym!\." MKDIR "!LOCALUSBARCHIVE!\!SiteAcronym!"
     IF NOT EXIST "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\." MKDIR "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains"
     IF NOT EXIST "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\." MKDIR "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a"
     IF NOT EXIST "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\." MKDIR "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b"
     IF NOT EXIST "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\." MKDIR "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c"
     REM Copy Train Files to New Directory
     IF EXIST *.csv COPY *.csv "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\"
     IF EXIST *.log COPY *.log "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\"
     IF EXIST *.tag COPY *.tag "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\"
     IF EXIST *.htm COPY *.htm "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\"
     IF EXIST *.png COPY *.png "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\"
     IF EXIST *.wav COPY *.wav "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\"
     IF EXIST *.mat (
       COPY *Accs_*.mat "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\"
       COPY *Mics_*.mat "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\"
       COPY whldets*.mat "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\"
       COPY rawres_*.mat "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\"
       COPY tvects_*.mat "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\"
     )
     REM Scan the CSV entries if trains are Tagged using fields ,N_Cars,N_Locos,N_CarsTagged,N_LocosTagged and if NOT zero, compress the RAW data *.dat files into a Archive in the train folder on the USB Drive.
     IF EXIST *.csv for /f "tokens=*" %%D in ('dir /b TRNTBL*.csv 2^>nul') DO for /f "skip=1 tokens=10,11,12,13,* delims=," %%E in (%%D) DO IF NOT "00"=="%%G%%H" IF NOT EXIST "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\%%a_%%b_%%c_#!SiteAcronym!#_RAW_DAT.7z" ECHO !TIME! Compressing %%a_%%b_%%c_#!SiteAcronym!#_RAW_DAT.7z *.dat &START "Compress %%a_%%b_%%c_#!SiteAcronym!#_RAW_DAT.7z *.dat" /NODE 0 /AFFINITY 0x2 /LOW /WAIT /MIN "%~dp07z.exe" a -y "!LOCALUSBARCHIVE!\!SiteAcronym!\Trains\%%a\%%b\%%c\%%a_%%b_%%c_#!SiteAcronym!#_RAW_DAT.7z" *.dat
    popd
  )
  REM Only mark the trainlist file Done if no errors occured during compression of all the results. If Error rename with the .do"tens" past the hour to mark for next re-try   i.e. do3 = about 3 mins past the next hour.
  IF !ERRORCOUNT! == 0 (ren "%TrainListDIR%\%%a_%%b_%%c.do" "%%a_%%b_%%c.done" && ECHO !TIME! File %%a_%%b_%%c.do is now %%a_%%b_%%c.done) ELSE (ren "%TrainListDIR%\%%a_%%b_%%c.do" "%%a_%%b_%%c.do!TIME:~-10,1!" &&ECHO !TIME! !ERRORCOUNT! Processing Errors, File %%a_%%b_%%c.do is now %%a_%%b_%%c.do!TIME:~-10,1!)

  REM Display what was found...
  ECHO !TIME! Processed !Sensor! train at !SiteAcronym! in %TRNROOT%\%%a\%%b\%%c\

  SET DiagnosticsAcronym=
  SET SiteAcronym=
  SET Sensor=
)

REM Cleanup any tempurary 7z files.
IF EXIST "%TRNROOT%\*.tmp" (
     ECHO %TIME% Removing extra 7z tmp files...
     FOR /f "tokens=* delims=" %%A IN ('DIR /B "%TRNROOT%\*.tmp"') DO ECHO Removing "%TRNROOT%\%%A" &&DEL /Q "%TRNROOT%\%%A"
)

endlocal
