:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::            Compress and Process Batch Script              ::
::                         V1.9                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2020/03/31                           ::
::                                                           ::
::          Makes use of 7z command line utilities           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@echo off
setlocal
:: Enter Configuration Parameters below;
::===============================================================

:: Change the Directories as required
IF NOT DEFINED OUTDIR SET FTPPTDIR=D:\Server\Share\Interris\OUT
IF NOT DEFINED TRNROOT SET TRNROOT=D:\Server\Share\Interris\IN


::===============================================================
:: SETUP Parameters needed
IF NOT EXIST "%TRNROOT%\." MKDIR "%TRNROOT%"
IF NOT EXIST "%TRNROOT%\..\Interris-Archive\." MKDIR "%TRNROOT%\..\Interris-Archive"
IF NOT EXIST "%OUTDIR%" MKDIR "%OUTDIR%"

:: Change to root of relative Path DIR. (for 7zip to add the path).
cd /d "%TRNROOT%"

ECHO %DATE% %TIME% Start  Loop, Checking for Interris files...
:: Compress Interris Feed file into daily archive before upload.
:: Get lastest list of trains to work on, then compress and move.
FOR /f "tokens=* delims=" %%A IN ('DIR /B') DO (
    "%~dp07z.exe" a -y "%TRNROOT%\..\Interris-Archive\Interris-%DATE:/=_%.7z" "%%A"
    MOVE "%%A" "%OUTDIR%\%%A"
)

endlocal
