:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::           E.M.S. Process Upload Batch Script              ::
::                         V1.0                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2021/06/25                           ::
::                                                           ::
::        Makes use of ncftput command line utilities        ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@echo off
setlocal ENABLEDELAYEDEXPANSION
:: Enter Configuration Parameters below;
::===============================================================
:: Primary Source Locations
IF NOT DEFINED TRNROOT SET TRNROOT=D:\Server
IF NOT DEFINED DiskPurgeList SET DiskPurgeList=C:\TrackIQ\DiskPurgeBatch\PurgeList

:: The Deafult Trainlist Directory
IF NOT DEFINED TrainListDIR SET TrainListDIR=%~dp0trainlist

:: FTP Parameters
SET URLUSERNAME=WaysideWeather
SET URLPASSWORD=Password@123
SET ncFTPParameters=-Z
SET URLDOMAIN=10.241.11.15
SET URLPATH=/



::===============================================================
:: SETUP Parameters needed
IF NOT EXIST "%TRNROOT%\trains" MKDIR "%TRNROOT%\trains"


cd /d "%TRNROOT%"
IF NOT EXIST "%TrainListDIR%\." MKDIR "%TrainListDIR%"

:: Generate Trainlist if not existant.
:: IF NOT EXIST %TRNROOT%\trainlist\. CALL %~dp0GenerateTrainlist.bat

:: Change to root of relative Path DIR. (for 7zip to add the path).
:: Main_Loop --
ECHO %TIME% Checking %TRNROOT%\trainlist for new entries...
:: Get lastest list of trains to work on, if file not exist, copy. Hence if previously deleted it would be copied again.
IF EXIST "%TRNROOT%\trainlist\." (
    FOR /f "tokens=* delims=" %%A IN ('DIR /B "%TRNROOT%\trainlist"') DO (
      IF NOT EXIST "%TrainListDIR%\%%A.do*" IF NOT EXIST "%TrainListDIR%\%%A.done" (copy /Y "%TRNROOT%\trainlist\%%A" "%TrainListDIR%\%%A.do" >nul && ECHO !TIME! File %%A.do Copied.)
    )
) ELSE (
    REM Tokens Needs to match the TRNROOT path used!
    for /f "tokens=7,8,9* delims=\" %%a in ('dir /ad /s /b "%TRNROOT%\trains\"') do if not "%%c"=="" if exist "%TRNROOT%\trains\%%a\%%b\%%c\*.gz" (echo.%%a_%%b_%%c 2>"%TrainListDIR%\%%a_%%b_%%c.do")
)
:: Check for trains that require a re-do for compression. The retry (.doX) is Skipped if the Hour (X) is the same as the current time. (i.e. X:43:23.00)
for /l %%Z in (0,1,9) DO (
  IF EXIST "%TrainListDIR%\*.do%%Z" (
    SET NOWTIMECOMPARE=!TIME:~-10,1!
    IF NOT "%%Z"=="!NOWTIMECOMPARE!" for /f "tokens=* delims=" %%a in ('dir /b "%TrainListDIR%\*.do%%Z"') do ren "%TrainListDIR%\%%a" "%%~na.do" && ECHO !TIME! File %%~na.do Retry
  )
)
ECHO %TIME% Clearing trainlist%SiteAcronym% of Purged Trains...
:: Remove trains from local trainlist that have been Purged from the Disk.
IF EXIST "%DiskPurgeList%\." (
  FOR /f "tokens=* delims=" %%A IN ('DIR /B "%DiskPurgeList%"') DO (
    IF EXIST "%TrainListDIR%\%%A.do" (DEL "%TrainListDIR%\%%A.do" && ECHO !TIME! File %%A.do Purged.)
    IF EXIST "%TrainListDIR%\%%A.done" (DEL "%TrainListDIR%\%%A.done" && ECHO !TIME! File %%A.done Purged.)
  )
) ELSE (
  REM Old Method has had situations where the system would report the path dosn't exist but it dose. Hence this re-triggers the trains to re transfer.
  FOR /F "tokens=1,2,3,4* delims=_. " %%a in ('DIR /B "%TrainListDIR%\*.done"') DO IF EXIST "%TRNROOT%\." IF NOT EXIST "%TRNROOT%\Trains\%%a\%%b\%%c\." (DEL "%TrainListDIR%\%%a_%%b_%%c.done" && ECHO !TIME! File %%a_%%b_%%c.done Deleted.)
)



ECHO %TIME% Processing Trains...
:: Compression loop of directories to work on with "do" Files.
FOR /F "tokens=1,2,3,4,5* delims=_. " %%a in ('DIR /B "%TrainListDIR%\*.do" 2^>nul') DO (

  FOR /F "tokens=*" %%g in ('DIR /B "Trains\%%a\%%b\%%c\EMS*.XML" 2^>nul') DO ECHO !TIME! %%g &"%~dp0ncftpput.exe" -u %URLUSERNAME% -p %URLPASSWORD% %ncFTPParameters% %URLDOMAIN% %URLPATH% Trains\%%a\%%b\%%c\%%g
  SET /A ERRORCOUNT= !ERRORCOUNT! + !ERRORLEVEL!
  rem pause

  REM Only mark the trainlist file Done if no errors occured during compression of all the results. If Error rename with the .do"tens" past the hour to mark for next re-try   i.e. do3 = about 3 mins past the next hour.
  IF !ERRORCOUNT! == 0 (ren "%TrainListDIR%\%%a_%%b_%%c.do" "%%a_%%b_%%c.done" && ECHO !TIME! File %%a_%%b_%%c.do is now %%a_%%b_%%c.done) ELSE (ren "%TrainListDIR%\%%a_%%b_%%c.do" "%%a_%%b_%%c.do!TIME:~-10,1!" &&ECHO !TIME! !ERRORCOUNT! Processing Errors, File %%a_%%b_%%c.do is now %%a_%%b_%%c.do!TIME:~-10,1!)

)

endlocal