:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::          Compress and Process RAW Batch Script            ::
::                         V1.5                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2020/03/31                           ::
::                                                           ::
::          Makes use of 7z command line utilities           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@echo off
setlocal
:: Find *.cmd file to use largest as the main script entry.
FOR /F "tokens=*" %%a in ('DIR /B /OS "%~dp0*.cmd"') DO SET FILE=%%a
:: Read the Parameter In from the main script entry.
FOR /F "tokens=1* delims==" %%a in ('findstr /B /C:"SET TRNROOT=" "%~dp0%FILE%"') DO SET TRNROOT=%%b
:: Enter Configuration Parameters below;
::===============================================================
:: Defined Site Acronym to a Static if required
REM SET SiteAcronymStatic=NwSt

:: Change the FTDiagnoticsArtefactsDIR path for the compressed RAW results.
SET FTDiagnoticsArtefactsDIR=D:\Server\Share\Diagnostics-Artefacts

IF NOT DEFINED TRNROOT SET TRNROOT=D:\Server

IF NOT DEFINED TrainListDIR SET TrainListDIR=%~dp0trainlistTIME

::===============================================================
:: SETUP Parameters needed
IF NOT EXIST "%~dp0\trnlist.txt" ECHO "trnlist.txt" file not found. Nothing to do! Exiting... &GOTO :EOF
IF NOT EXIST "%TrainListDIR%\." MKDIR "%TrainListDIR%"
IF NOT EXIST "%FTDiagnoticsArtefactsDIR%" MKDIR "%FTDiagnoticsArtefactsDIR%"
IF NOT EXIST "%~dp0\#%SiteAcronym%#" ECHO. 2>"%~dp0\#%SiteAcronym%#"
:: Detect if Comprocess is named Comprocess.D (drive letter) to define the Drive to monitor.
CALL :FolderNameDriveLetterDetect
IF DEFINED DRV_TO_MONITOR SET TRNROOT=%DRV_TO_MONITOR%%TRNROOT:~1%

:: Change to root of relative Path DIR. (for 7zip to add the path).
cd /d "%TRNROOT%"
:Main_Loop
ECHO %TIME% Start  Loop, Checking for Trains...| "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"
:: Search Data Drive for trains matching trains times in %~dp0\trnlist.txt and create a list of trains to process. Train times must be one per line and in the format DD-MMM-YYYY HH:MM:SS e.g. "27-Mar-2014 07:11:42"
for /f %%A IN ('dir %TRNROOT%\trains\analysis.log /b /s') DO for /f "tokens=10,11,*" %%D IN ('findstr /C:"Finished Waiting" %%A') DO for /f "tokens=*" %%G in (%~dp0\trnlist.txt) DO IF "%%D %%E"=="%%G" for /f "tokens=4,5,6,* delims=\" %%I IN ("%%A") DO ECHO Found %%G 2>%TrainListDIR%\%%I_%%J_%%K.do | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"

:: Compression loop of directories to work on
FOR /F "tokens=1,2,3,4* delims=_ " %%a in ('DIR /B "%TrainListDIR%" 2^>nul') DO (
  REM Allow the Use of a Staticly Defined SiteAcronym for Backwards Compatability
  IF DEFINED SiteAcronymStatic SET SiteAcronym=%SiteAcronymStatic%
  REM Find Site Name String in the analysis.log file.
  IF NOT DEFINED SiteAcronymStatic for /f "tokens=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,*" %%H IN ('findstr /B /c:"********" Trains\%%a\%%b\%%c\analysis.log') DO (
    SET SH=%%H
    SET SI=%%I
    SET SJ=%%J
    SET SK=%%K
    SET SL=%%L
    SET SM=%%M
    SET SN=%%N
    SET SO=%%O
    SET SP=%%P
    SET SQ=%%Q
    SET SR=%%R
    SET SS=%%S
    SET ST=%%T
    SET SU=%%U
    SET SV=%%V
    SET SW=%%W
    SET SX=%%X
    SET SY=%%Y
    SET SZ=%%Z
    SET SH=!SH:~0,1!
    SET SI=!SI:~0,1!
    SET SJ=!SJ:~0,1!
    SET SK=!SK:~0,1!
    SET SL=!SL:~0,1!
    SET SM=!SM:~0,1!
    SET SN=!SN:~0,1!
    SET SO=!SO:~0,1!
    SET SP=!SP:~0,1!
    SET SQ=!SQ:~0,1!
    SET SR=!SR:~0,1!
    SET SS=!SS:~0,1!
    SET ST=!ST:~0,1!
    SET SU=!SU:~0,1!
    SET SV=!SV:~0,1!
    SET SW=!SW:~0,1!
    SET SX=!SX:~0,1!
    SET SY=!SY:~0,1!
    SET SZ=!SZ:~0,1!
    IF "*"=="!SJ!" SET SiteAcronym=%%I
    IF "*"=="!SK!" SET SiteAcronym=%%I%%J
    IF "*"=="!SL!" SET SiteAcronym=%%I%%J%%K
    IF "*"=="!SM!" SET SiteAcronym=%%I%%J%%K%%L
    IF "*"=="!SN!" SET SiteAcronym=%%I%%J%%K%%L%%M
    IF "*"=="!SO!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N
    IF "*"=="!SP!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O
    IF "*"=="!SQ!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P
    IF "*"=="!SR!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q
    IF "*"=="!SS!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R
    IF "*"=="!ST!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S
    IF "*"=="!SU!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T
    IF "*"=="!SV!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T%%U
    IF "*"=="!SW!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T%%U%%V
    IF "*"=="!SX!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T%%U%%V%%W
    IF "*"=="!SY!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T%%U%%V%%W%%X
    IF "*"=="!SZ!" SET SiteAcronym=%%I%%J%%K%%L%%M%%N%%O%%P%%Q%%R%%S%%T%%U%%V%%W%%X%%Y
  )
  REM Find the System Sensor Type in the analysis.log file Used for Diagnostics Files and 7z Filename generation but not end folder name.
  for /f "tokens=*" %%H IN ('findstr /c:"-Algorithms" Trains\%%a\%%b\%%c\analysis.log') DO (
    for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "RailBAM-"') DO SET Sensor=RailBAM
    for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "RailCAM"') DO SET Sensor=RailCAM
    for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "NSMON-"') DO SET Sensor=RailNSMON
    for /f "tokens=*" %%I IN ('ECHO %%H^|find /i "WCM-"') DO SET Sensor=WCM2
  )
  REM Should anything go wrong, Mark as Faulty and Continue.
  IF NOT DEFINED Sensor ECHO !TIME! ERROR Detecting Sensor in \%%a\%%b\%%c\ &SET Sensor=ERROR
  IF NOT DEFINED SiteAcronym ECHO !TIME! ERROR Detecting SiteAcronym in \%%a\%%b\%%c\ &SET SiteAcronym=Faulty
  REM Define Variables and Create Files for Processing.
  SET DiagnosticsAcronym=!SiteAcronym!!Sensor!
  IF NOT EXIST "%~dp0#!SiteAcronym!#" ECHO. 2>"%~dp0#!SiteAcronym!#"
  IF NOT EXIST "%~dp0#!DiagnosticsAcronym!#" ECHO. 2>"%~dp0#!DiagnosticsAcronym!#"


  REM FTF1DIR  (FleetOne Data Files)
  REM Compress files into one Archive and only remove the Archive bit of the trainlist file if no errors occured during compression of the results
  "%~dp07z.exe" a -y "%FTDiagnoticsArtefactsDIR%\%%a-%%b-%%c#%DiagnosticsAcronym%#_RAW.7z" "%~dp0#%DiagnosticsAcronym%#" "Trains\%%a\%%b\%%c\*.log" "Trains\%%a\%%b\%%c\*.htm" "Trains\%%a\%%b\%%c\whldets.mat" "Trains\%%a\%%b\%%c\*_*.dat" "Trains\%%a\%%b\%%c\*Mics_*.mat" "Trains\%%a\%%b\%%c\*.tag" "Trains\%%a\%%b\%%c\*.txt" -xr^^!SMS*.txt &&(ren "%TrainListDIR%\%%a_%%b_%%c.do" "%%a_%%b_%%c.done" && ECHO !TIME! File %%a_%%b_%%c.do is now %%a_%%b_%%c.done) | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"

)

:: Delete Compressed Trains from Trainlist (CleanUp process.)
FOR /F "tokens=1,2,3,4* delims=_ " %%a in ('DIR /B "%TrainListDIR%\*.done"') DO (DEL "%TrainListDIR%\%%a_%%b_%%c.do" && ECHO File %%a_%%b_%%c.do Deleted.) | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"

endlocal
timeout /t 5
goto :eof

:: Tests path variables to detect only parent folder.
:SHIFTVARS
SET ParentFolder=%1
SET RunBatchTest=%2
IF "%RunBatchTest%"=="" exit /b
SHIFT
GOTO :SHIFTVARS
exit /b

:FolderNameDriveLetterDetect
:: Parent Folder Name Detection
SET RUNPATH=%~dp0
SET RUNPATH=%RUNPATH: =#%
CALL :SHIFTVARS %RUNPATH:\= %
SET ParentFolder=%ParentFolder:#= %
:: Assign "DRV_TO_MONITOR" based on this folder name (First Charator after. IF EXISTS)
for /f "tokens=2 delims=." %%A IN ("%ParentFolder%") DO IF EXIST "%%A:\." SET DRV_TO_MONITOR=%%A
IF DEFINED DRV_TO_MONITOR SET DRV_TO_MONITOR=%DRV_TO_MONITOR:~0,1%
exit /b
