:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::            Compress and Process Batch Script              ::
::                         V6.6                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2022/10/12                           ::
::                                                           ::
::          Makes use of 7z command line utilities           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@echo off
setlocal ENABLEDELAYEDEXPANSION
:: Enter Configuration Parameters below;
::===============================================================
:: Primary Source Locations
IF NOT DEFINED TRNROOT SET TRNROOT=D:\Server
IF NOT DEFINED DiskPurgeList SET DiskPurgeList=C:\TrackIQ\DiskPurgeBatch\PurgeList

:: The Deafult Trainlist Directory
IF NOT DEFINED TrainListDIR SET TrainListDIR=%~dp0trainlist
IF NOT DEFINED TrainListAfterReAnalysis SET TrainListAfterReAnalysis=%TRNROOT%\TrainListAfterReAnalysis

:: The amount of time to wait before launching re analysis session
IF NOT DEFINED ReAnalysisDelay SET ReAnalysisDelay=1200

:: The Following Parameters are Optionally set;



::===============================================================
:: SETUP Parameters needed
IF NOT EXIST "%TRNROOT%\trains" MKDIR "%TRNROOT%\trains"


cd /d "%TRNROOT%"
IF NOT EXIST "%TrainListDIR%\." MKDIR "%TrainListDIR%"

:: Generate Trainlist if not existant.
:: IF NOT EXIST %TRNROOT%\trainlist\. CALL %~dp0GenerateTrainlist.bat

:: Change to root of relative Path DIR. (for 7zip to add the path).
:: Main_Loop --
ECHO %TIME% Checking %TRNROOT%\trainlist for new entries...  | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"
:: Get lastest list of trains to work on, if file not exist, copy. Hence if previously deleted it would be copied again.
IF EXIST "%TRNROOT%\trainlist\." (
    FOR /f "tokens=* delims=" %%A IN ('DIR /B "%TRNROOT%\trainlist"') DO (
      IF NOT EXIST "%TrainListDIR%\%%A.do*" IF NOT EXIST "%TrainListDIR%\%%A.done" (copy /Y "%TRNROOT%\trainlist\%%A" "%TrainListDIR%\%%A.do" >nul && ECHO !TIME! File %%A.do Copied. | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log") 
    )
) ELSE (
    REM Tokens Needs to match the TRNROOT path used!
    for /f "tokens=7,8,9* delims=\" %%a in ('dir /ad /s /b "%TRNROOT%\trains\"') do if not "%%c"=="" if exist "%TRNROOT%\trains\%%a\%%b\%%c\*.gz" (echo.%%a_%%b_%%c 2>"%TrainListDIR%\%%a_%%b_%%c.do")
)

:: Check for trains that require a re-do for compression. The retry (.doX) is Skipped if the Hour (X) is the same as the current time. (i.e. X:43:23.00)
for /l %%Z in (0,1,9) DO (
  IF EXIST "%TrainListDIR%\*.do%%Z" (
    SET NOWTIMECOMPARE=!TIME:~-10,1!
    IF NOT "%%Z"=="!NOWTIMECOMPARE!" for /f "tokens=* delims=" %%a in ('dir /b "%TrainListDIR%\*.do%%Z"') do ren "%TrainListDIR%\%%a" "%%~na.do" && (ECHO !TIME! File %%~na.do Retry | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log")
  )
)

ECHO %TIME% Clearing trainlist%SiteAcronym% of Purged Trains...  | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"
:: Remove trains from local trainlist that have been Purged from the Disk.
IF EXIST "%DiskPurgeList%\." (
  FOR /f "tokens=* delims=" %%A IN ('DIR /B "%DiskPurgeList%"') DO (
    IF EXIST "%TrainListDIR%\%%A.do" (DEL "%TrainListDIR%\%%A.do" && ECHO !TIME! File %%A.do Purged. | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log")
    IF EXIST "%TrainListDIR%\%%A.done" (DEL "%TrainListDIR%\%%A.done" && ECHO !TIME! File %%A.done Purged. | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log")
  )
) ELSE (
  REM Old Method has had situations where the system would report the path dosn't exist but it dose. Hence this re-triggers the trains to re transfer.
  FOR /F "tokens=1,2,3,4* delims=_. " %%a in ('DIR /B "%TrainListDIR%\*.done"') DO IF EXIST "%TRNROOT%\." IF NOT EXIST "%TRNROOT%\Trains\%%a\%%b\%%c\." (DEL "%TrainListDIR%\%%a_%%b_%%c.done" && ECHO !TIME! File %%a_%%b_%%c.done Deleted. | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log")
)

ECHO %TIME% Processing Trains... | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"
:: Compression loop of directories to work on with "do" Files.
FOR /F "tokens=1,2,3,4,5* delims=_. " %%a in ('DIR /B "%TrainListDIR%\*.do" 2^>nul') DO (
  ECHO !TIME! ReAnalysis of %TRNROOT%\%%a\%%b\%%c | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"
  start cmd /c "%~dp0run_run_reanalyse.bat" %%a %%b %%b %%c %%c false tvects_N.mat
)
endlocal
