:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::            Create Scheduled Task Batch Script             ::
::                         V3.6                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2020/04/06                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@ECHO OFF
setlocal
:: Version of Windows Detection
for /f "tokens=2 delims=][" %%A in ('ver^|find "Windows"') DO for /f "tokens=2,3,4 delims=. " %%I in ("%%A") DO IF "%%I"=="5" (SET winVER=XP) ELSE (SET winVER=7)
:: Parent Folder Name Detection
SET RUNPATH=%~dp0
SET RUNPATH=%RUNPATH: =#%
CALL :SHIFTVARS %RUNPATH:\= %
SET ParentFolder=%ParentFolder:#= %
:: Find *.cmd file to use largest as the main Scheduled Task Entry.
FOR /F "tokens=*" %%a in ('DIR /B /OS "%~dp0\*.cmd"') DO SET FILE=%%a
:: Creates Scheduled Task to Run Every 5 Mins
IF %winVER%.==7. schtasks /create /sc DAILY /RI 5 /ST 00:05 /DU 24:00 /tn "TrackIQ\%ParentFolder%" /tr "'%~dp0%FILE%'" /ru System
IF %winVER%.==XP. schtasks /create /sc MINUTE /mo 5 /tn "%ParentFolder%" /tr "\"%~dp0%FILE%\"" /ru System
SET LoopSleepSeconds=10
IF EXIST %~dp0choice.exe (%~dp0Choice.exe /N /T:Y,%LoopSleepSeconds%) else (choice /N /C YN /D Y /T %LoopSleepSeconds%)
endlocal
GOTO :EOF

:: Tests path variables to detect only parent folder.
:SHIFTVARS
SET ParentFolder=%1
SET RunBatchTest=%2
IF "%RunBatchTest%"=="" exit /b
SHIFT
GOTO :SHIFTVARS
exit /b