:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::            Compress and Process Batch Script              ::
::                         V6.9                              ::
::                                                           ::
::                  by Bernard Buterin                       ::
::                      2023/11/27                           ::
::                                                           ::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
@echo off
setlocal
:: Enter Configuration Parameters below;
::===============================================================
:: Primary Source Location
SET TRNROOT=D:\Server

:: Change the FTPDIR number if you need more than one copy.
SET FTF1DIR=D:\Server\Share\FleetOne
SET FTF1ArtefactsDIR=D:\Server\Share\FleetOne-Artefacts
:: Define Path if Required.
SET FTDiagnoticsArtefactsDIR=D:\Server\Share\Diagnostics-Artefacts

:: Configure a Defined Site Name to be used Instead of the Auto Detected Name from Analysis.log
:: SET SiteAcronymStatic=DefinedSiteName

:: If a copy of the compressed files is needed, define one of these variables (For the type needed) and the results will be duplicated into the defined folder.
:: SET FTF1DIRCPY=D:\Server\Share\FleetOneCOPY
:: SET FTF1ArtefactsDIRCPY=D:\Server\Share\FleetOneCOPY-Artefacts
:: SET FTDiagnoticsArtefactsDIRCPY=D:\Server\Share\DiagnosticsCOPY-Artefacts

:: To prevent rawres_*.MAT files to be transfered to FleetOne. Define REDUCEF1Artefacts to any value to skip sending rawres_*.MAT files to FleetOne.
:: SET REDUCEF1Artefacts=YES
:: To Store More trains on Disk, Compress RAW DAT Files. (Feature migrated away from Analysis software.) Define CompressRAWDatFiles to compress.
:: SET CompressRAWDatFiles=AnyValue
:: To Reduce the recorded video file in a compatiable format, specify the MJPEG Quality
SET CompressAVIFileQuality=90
:: To Enable Local USB Archive of Tagged Trains define LOCALUSBARCHIVE with a drive letter
:: SET LOCALUSBARCHIVE=E:
:: ~30 second sleep Loop to reduce hard drive hammering if more frequent. (Empty to disable Loop)
SET LoopSleepSeconds=30
:: Number of days to keep log files
SET OutputLogFiles=30

::===============================================================
:: SETUP Parameters needed
IF NOT EXIST "%~dp0log\." mkdir "%~dp0log"
ECHO %TIME% ComProcess Start| "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"
:: Detect if Comprocess is named Comprocess.D (drive letter) to define the Drive to monitor.
CALL :FolderNameDriveLetterDetect
IF DEFINED DRV_TO_MONITOR SET TRNROOT=%DRV_TO_MONITOR%%TRNROOT:~1%

:: Determine DiskPurge PurgeList Folder Automatically. (If DiskPurge is not re-named, use it's path. If Diskpurge is upgraded and uses the new folder name parameter, use the matching TRNROOT folder name)
IF EXIST "C:\TrackIQ\DiskPurgeBatch\."  SET DiskPurgeList=C:\TrackIQ\DiskPurgeBatch\PurgeList
  SET TRNROOTDRV=%TRNROOT:~0,1%
IF EXIST "C:\TrackIQ\DiskPurgeBatch.%TRNROOTDRV%\." SET DiskPurgeList=C:\TrackIQ\DiskPurgeBatch.%TRNROOTDRV%\PurgeList
  SET TRNROOTDRV=
:Main_Loop
:: Run One Of These...

:: Run the Compression Process for WPU
CALL "%~dp0ProcessWPU.bat"  | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"

:: Run ProcessInterris Feed to archive prior upload
:: CALL "%~dp0ProcessInterris.bat"  | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"

:: Run ProcessServer to archive Site data on the server, also change the LoopSleepSeconds to a higher value like 86400 (Daily)
:: CALL "%~dp0ProcessServer.bat"  | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"

:: Run the Rename and Transfer whldets.mat Batch Script
:: CALL "%~dp0RenTx_Whldets.bat"  | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log"

:: Tidy up empty directories
:: robocopy "%TRNROOT%\trains" "%TRNROOT%\trains" /s /move

:: Tidy up Old Log Files based on how many files we want to keep.
for /f "tokens=* skip=%OutputLogFiles%" %%A IN ('dir /B /O-D "%~dp0log\LOG.*.log"') DO DEL "%~dp0log\%%A"

:: Repeat loop from here.
IF DEFINED LoopSleepSeconds ECHO %TIME% Waiting %LoopSleepSeconds% Seconds... | "%~dp0TEE" -a "%~dp0log\LOG.%DATE:/=-%.%~n0.log" &CALL :RUNDELAY %LoopSleepSeconds% &GOTO Main_Loop
endlocal
goto :eof


:RUNDELAY
SET RUNDELAYseconds=%1
IF NOT DEFINED RUNDELAYseconds exit /b
IF %RUNDELAYseconds%==0  exit /b
IF EXIST %WINDIR%\system32\choice.exe (choice /N /C YN /D Y /T %RUNDELAYseconds%) ELSE (SET /A RUNDELAYPingseconds=%RUNDELAYseconds%+1 &ping 127.0.0.1 -n %RUNDELAYPingseconds%) >nul
exit /b


:: Tests path variables to detect only parent folder.
:SHIFTVARS
SET ParentFolder=%1
SET RunBatchTest=%2
IF "%RunBatchTest%"=="" exit /b
SHIFT
GOTO :SHIFTVARS
exit /b

:FolderNameDriveLetterDetect
:: Parent Folder Name Detection
SET RUNPATH=%~dp0
SET RUNPATH=%RUNPATH: =#%
CALL :SHIFTVARS %RUNPATH:\= %
SET ParentFolder=%ParentFolder:#= %
:: Assign "DRV_TO_MONITOR" based on this folder name (First Charator after. IF EXISTS)
for /f "tokens=2 delims=." %%A IN ("%ParentFolder%") DO IF EXIST "%%A:\." SET DRV_TO_MONITOR=%%A
IF DEFINED DRV_TO_MONITOR SET DRV_TO_MONITOR=%DRV_TO_MONITOR:~0,1%
exit /b
